/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class XSiteStateTransferConfiguration
extends ConfigurationElement<XSiteStateTransferConfiguration> {
    public static final int DEFAULT_CHUNK_SIZE = 512;
    public static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toMillis(20L);
    public static final int DEFAULT_MAX_RETRIES = 30;
    public static final long DEFAULT_WAIT_TIME = TimeUnit.SECONDS.toMillis(2L);
    public static final AttributeDefinition<Integer> CHUNK_SIZE = AttributeDefinition.builder(Attribute.CHUNK_SIZE, Integer.valueOf(512)).immutable().build();
    public static final AttributeDefinition<Long> TIMEOUT = AttributeDefinition.builder(Attribute.TIMEOUT, Long.valueOf(DEFAULT_TIMEOUT)).build();
    public static final AttributeDefinition<Integer> MAX_RETRIES = AttributeDefinition.builder(Attribute.MAX_RETRIES, Integer.valueOf(30)).build();
    public static final AttributeDefinition<Long> WAIT_TIME = AttributeDefinition.builder(Attribute.WAIT_TIME, Long.valueOf(DEFAULT_WAIT_TIME)).build();
    public static final AttributeDefinition<XSiteStateTransferMode> MODE = AttributeDefinition.builder(Attribute.MODE, XSiteStateTransferMode.MANUAL).build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(XSiteStateTransferConfiguration.class, CHUNK_SIZE, TIMEOUT, MAX_RETRIES, WAIT_TIME, MODE);
    }

    public XSiteStateTransferConfiguration(AttributeSet attributes) {
        super(Element.STATE_TRANSFER, attributes, new ConfigurationElement[0]);
    }

    public int chunkSize() {
        return this.attributes.attribute(CHUNK_SIZE).get();
    }

    public long timeout() {
        return this.attributes.attribute(TIMEOUT).get();
    }

    public int maxRetries() {
        return this.attributes.attribute(MAX_RETRIES).get();
    }

    public long waitTime() {
        return this.attributes.attribute(WAIT_TIME).get();
    }

    public XSiteStateTransferMode mode() {
        return this.attributes.attribute(MODE).get();
    }
}

