/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class XSiteStateTransferConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<XSiteStateTransferConfiguration> {
    private final BackupConfigurationBuilder backupConfigurationBuilder;
    private final AttributeSet attributes = XSiteStateTransferConfiguration.attributeDefinitionSet();

    public XSiteStateTransferConfigurationBuilder(ConfigurationBuilder builder, BackupConfigurationBuilder backupConfigurationBuilder) {
        super(builder);
        this.backupConfigurationBuilder = backupConfigurationBuilder;
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public void validate() {
        int chunkSize = this.attributes.attribute(StateTransferConfiguration.CHUNK_SIZE).get();
        if (chunkSize <= 0) {
            throw Log.CONFIG.invalidChunkSize(chunkSize);
        }
        if (this.attributes.attribute(XSiteStateTransferConfiguration.TIMEOUT).get() <= 0L) {
            throw Log.CONFIG.invalidXSiteStateTransferTimeout();
        }
        if (this.attributes.attribute(XSiteStateTransferConfiguration.WAIT_TIME).get() <= 0L) {
            throw Log.CONFIG.invalidXSiteStateTransferWaitTime();
        }
        XSiteStateTransferMode mode = this.attributes.attribute(XSiteStateTransferConfiguration.MODE).get();
        if (mode == null) {
            throw Log.CONFIG.invalidXSiteStateTransferMode();
        }
        if (mode == XSiteStateTransferMode.AUTO && this.backupConfigurationBuilder.strategy() == BackupConfiguration.BackupStrategy.SYNC) {
            throw Log.CONFIG.autoXSiteStateTransferModeNotAvailableInSync();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.validate();
    }

    public final XSiteStateTransferConfigurationBuilder chunkSize(int chunkSize) {
        this.attributes.attribute(XSiteStateTransferConfiguration.CHUNK_SIZE).set(chunkSize);
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder timeout(long timeout) {
        this.attributes.attribute(XSiteStateTransferConfiguration.TIMEOUT).set(timeout);
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder maxRetries(int maxRetries) {
        this.attributes.attribute(XSiteStateTransferConfiguration.MAX_RETRIES).set(maxRetries);
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder waitTime(long waitingTimeBetweenRetries) {
        this.attributes.attribute(XSiteStateTransferConfiguration.WAIT_TIME).set(waitingTimeBetweenRetries);
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder mode(XSiteStateTransferMode mode) {
        this.attributes.attribute(XSiteStateTransferConfiguration.MODE).set(mode);
        return this;
    }

    public final BackupConfigurationBuilder backup() {
        return this.backupConfigurationBuilder;
    }

    @Override
    public XSiteStateTransferConfiguration create() {
        return new XSiteStateTransferConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<XSiteStateTransferConfiguration> read(XSiteStateTransferConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "XSiteStateTransferConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + "]";
    }
}

