/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.format;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;

public final class PropertyFormatter {
    private static Method plainToString = null;
    private final String globalConfigPrefix;
    private final String configPrefix;

    public PropertyFormatter() {
        this("", "");
    }

    public PropertyFormatter(String globalConfigPrefix, String configPrefix) {
        this.globalConfigPrefix = globalConfigPrefix;
        this.configPrefix = configPrefix;
    }

    private static List<Method> getConfigMethods(Class<?> clazz) {
        ArrayList<Method> r = new ArrayList<Method>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method m4 : c.getDeclaredMethods()) {
                if (!Modifier.isPublic(m4.getModifiers()) || Modifier.isStatic(m4.getModifiers()) || m4.getParameterCount() != 0 || m4.isAnnotationPresent(Deprecated.class) || "hashCode".equals(m4.getName()) || "toString".equals(m4.getName()) || "toProperties".equals(m4.getName())) continue;
                m4.setAccessible(true);
                r.add(m4);
            }
        }
        return r;
    }

    private static boolean hasPlainToString(Object obj) {
        Class<?> cls = obj.getClass();
        try {
            if (cls.getMethod("toString", new Class[0]) == plainToString) {
                return true;
            }
            String plainToStringValue = cls.getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
            return plainToStringValue.equals(obj.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void reflect(Object obj, Properties p, String prefix) {
        try {
            if (obj == null) {
                p.put(prefix, "null");
                return;
            }
            Class<?> cls = obj.getClass();
            if (cls.getName().startsWith("org.infinispan.config") && !cls.isEnum()) {
                for (Method m4 : PropertyFormatter.getConfigMethods(obj.getClass())) {
                    try {
                        String prefixDot = prefix == null || prefix.isEmpty() ? "" : prefix + ".";
                        PropertyFormatter.reflect(m4.invoke(obj, new Object[0]), p, prefixDot + m4.getName());
                    }
                    catch (IllegalAccessException prefixDot) {}
                }
            } else if (Collection.class.isAssignableFrom(cls)) {
                Collection collection = (Collection)obj;
                Iterator iter = collection.iterator();
                for (int i = 0; i < collection.size(); ++i) {
                    PropertyFormatter.reflect(iter.next(), p, prefix + "[" + i + "]");
                }
            } else if (cls.isArray()) {
                Object[] a = (Object[])obj;
                for (int i = 0; i < a.length; ++i) {
                    PropertyFormatter.reflect(a[i], p, prefix + "[" + i + "]");
                }
            } else if (PropertyFormatter.hasPlainToString(obj)) {
                p.put(prefix, cls.getName());
            } else {
                p.put(prefix, obj.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Properties format(Configuration configuration) {
        Properties properties = new Properties();
        PropertyFormatter.reflect(configuration, properties, this.configPrefix);
        return properties;
    }

    public Properties format(GlobalConfiguration configuration) {
        Properties properties = new Properties();
        PropertyFormatter.reflect(configuration, properties, this.globalConfigPrefix);
        return properties;
    }

    static {
        try {
            plainToString = Object.class.getMethod("toString", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

