/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AllowListConfigurationBuilder;

@BuiltBy(value=AllowListConfigurationBuilder.class)
public class AllowListConfiguration {
    static final AttributeDefinition<Set<String>> CLASSES = AttributeDefinition.builder("classes", new HashSet(), Set.class).initializer(HashSet::new).immutable().build();
    static final AttributeDefinition<List<String>> REGEXPS = AttributeDefinition.builder("regexps", new ArrayList(), List.class).initializer(ArrayList::new).immutable().build();
    private final AttributeSet attributes;
    private final ClassLoader classLoader;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AllowListConfiguration.class, CLASSES, REGEXPS);
    }

    AllowListConfiguration(AttributeSet attributes, ClassLoader classLoader) {
        this.attributes = attributes.checkProtection();
        this.classLoader = classLoader;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ClassAllowList create() {
        return new ClassAllowList((Collection<String>)this.attributes.attribute(CLASSES).get(), this.attributes.attribute(REGEXPS).get(), this.classLoader);
    }

    public Set<String> getClasses() {
        return this.attributes.attribute(CLASSES).get();
    }

    public List<String> getRegexps() {
        return this.attributes.attribute(REGEXPS).get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllowListConfiguration that = (AllowListConfiguration)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }

    public String toString() {
        return "AllowListConfiguration{attributes=" + String.valueOf(this.attributes) + "}";
    }
}

