/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Objects;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.configuration.attributes.PropertiesAttributeSerializer;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class GlobalJmxConfiguration
extends GlobalJmxStatisticsConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder(Attribute.ENABLED, Boolean.valueOf(false)).immutable().build();
    public static final AttributeDefinition<String> DOMAIN = AttributeDefinition.builder(Attribute.DOMAIN, "org.infinispan").immutable().build();
    public static final AttributeDefinition<MBeanServerLookup> MBEAN_SERVER_LOOKUP = AttributeDefinition.builder(Attribute.MBEAN_SERVER_LOOKUP, null, MBeanServerLookup.class).copier(IdentityAttributeCopier.identityCopier()).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
    public static final AttributeDefinition<TypedProperties> PROPERTIES = AttributeDefinition.builder(Element.PROPERTIES, null, TypedProperties.class).immutable().initializer(TypedProperties::new).serializer(PropertiesAttributeSerializer.PROPERTIES).build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> enabled;
    private final org.infinispan.commons.configuration.attributes.Attribute<String> domain;
    private final org.infinispan.commons.configuration.attributes.Attribute<MBeanServerLookup> mBeanServerLookup;
    private final org.infinispan.commons.configuration.attributes.Attribute<TypedProperties> properties;
    private final String cacheManagerName;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalJmxConfiguration.class, ENABLED, DOMAIN, MBEAN_SERVER_LOOKUP, PROPERTIES);
    }

    GlobalJmxConfiguration(AttributeSet attributes, String cacheManagerName) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.domain = attributes.attribute(DOMAIN);
        this.mBeanServerLookup = attributes.attribute(MBEAN_SERVER_LOOKUP);
        this.properties = attributes.attribute(PROPERTIES);
        this.cacheManagerName = cacheManagerName;
    }

    @Override
    public boolean enabled() {
        return this.enabled.get();
    }

    @Override
    public String domain() {
        return this.domain.get();
    }

    @Override
    public TypedProperties properties() {
        return this.properties.get();
    }

    @Override
    @Deprecated
    public String cacheManagerName() {
        return this.cacheManagerName;
    }

    @Override
    public MBeanServerLookup mbeanServerLookup() {
        return this.mBeanServerLookup.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalJmxConfiguration that = (GlobalJmxConfiguration)o;
        if (!Objects.equals(this.cacheManagerName, that.cacheManagerName)) {
            return false;
        }
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        int result = this.cacheManagerName != null ? this.cacheManagerName.hashCode() : 0;
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GlobalJmxConfiguration [cacheManagerName='" + this.cacheManagerName + "', attributes=" + String.valueOf(this.attributes) + "]";
    }
}

