/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;

public class GlobalSecurityConfiguration {
    private final GlobalAuthorizationConfiguration authorization;
    public static final AttributeDefinition<Integer> CACHE_SIZE = AttributeDefinition.builder("securityCacheSize", Integer.valueOf(1000)).build();
    public static final AttributeDefinition<Long> CACHE_TIMEOUT = AttributeDefinition.builder("securityCacheTimeout", Long.valueOf(TimeUnit.MINUTES.toMillis(5L))).build();
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalSecurityConfiguration.class, CACHE_SIZE, CACHE_TIMEOUT);
    }

    public GlobalSecurityConfiguration(GlobalAuthorizationConfiguration authorization, AttributeSet attributes) {
        this.authorization = authorization;
        this.attributes = attributes;
    }

    public GlobalAuthorizationConfiguration authorization() {
        return this.authorization;
    }

    public long securityCacheSize() {
        return this.attributes.attribute(CACHE_SIZE).get().intValue();
    }

    public long securityCacheTimeout() {
        return this.attributes.attribute(CACHE_TIMEOUT).get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSecurityConfiguration that = (GlobalSecurityConfiguration)o;
        return Objects.equals(this.authorization, that.authorization) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.authorization, this.attributes);
    }

    public String toString() {
        return "GlobalSecurityConfiguration{authorization=" + String.valueOf(this.authorization) + ", attributes=" + String.valueOf(this.attributes) + "}";
    }
}

