/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolConfiguration;

public class ThreadPoolConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<ThreadPoolConfiguration> {
    String name;
    ThreadFactory threadFactory;
    ThreadPoolExecutorFactory threadPoolFactory;

    public ThreadPoolConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    @Override
    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    @Override
    public void validate() {
        if (this.threadPoolFactory != null) {
            this.threadPoolFactory.validate();
        }
    }

    public ThreadPoolConfigurationBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ThreadPoolConfigurationBuilder threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public ThreadPoolConfigurationBuilder threadPoolFactory(ThreadPoolExecutorFactory threadPoolFactory) {
        this.threadPoolFactory = threadPoolFactory;
        return this;
    }

    @Override
    public ThreadPoolConfiguration create() {
        return new ThreadPoolConfiguration(this.name, this.threadFactory, this.threadPoolFactory);
    }

    public ThreadPoolConfigurationBuilder read(ThreadPoolConfiguration template, Combine combine) {
        this.threadFactory = template.threadFactory();
        this.threadPoolFactory = template.threadPoolFactory();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadPoolConfigurationBuilder that = (ThreadPoolConfigurationBuilder)o;
        if (this.threadPoolFactory != null ? !this.threadPoolFactory.equals(that.threadPoolFactory) : that.threadPoolFactory != null) {
            return false;
        }
        return !(this.threadFactory != null ? !this.threadFactory.equals(that.threadFactory) : that.threadFactory != null);
    }

    public int hashCode() {
        int result = this.threadFactory != null ? this.threadFactory.hashCode() : 0;
        result = 31 * result + (this.threadPoolFactory != null ? this.threadPoolFactory.hashCode() : 0);
        return result;
    }
}

