/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.marshall.core.Ids;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class MetadataTransientCacheEntry
extends AbstractInternalCacheEntry
implements MetadataAware {
    protected Metadata metadata;
    protected long lastUsed;

    public MetadataTransientCacheEntry(Object key, Object value, Metadata metadata, long lastUsed) {
        this(key, value, null, metadata, lastUsed);
    }

    protected MetadataTransientCacheEntry(Object key, Object value, PrivateMetadata internalMetadata, Metadata metadata, long lastUsed) {
        super(key, value, internalMetadata);
        this.metadata = metadata;
        this.lastUsed = lastUsed;
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.lastUsed = currentTimeMillis;
    }

    @Override
    public void reincarnate(long now) {
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean canExpireMaxIdle() {
        return true;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransient(this.metadata.maxIdle(), this.lastUsed, now);
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public final long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getExpiryTime() {
        long maxIdle = this.metadata.maxIdle();
        return maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
    }

    @Override
    public final long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    public InternalCacheValue<?> toInternalCacheValue() {
        return new MetadataTransientCacheValue(this.value, this.internalMetadata, this.metadata, this.lastUsed);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", metadata=").append(this.metadata);
        builder.append(", lastUsed=").append(this.lastUsed);
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, MetadataTransientCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(ice.value);
            output.writeObject(ice.internalMetadata);
            output.writeObject(ice.metadata);
            UnsignedNumeric.writeUnsignedLong(output, ice.lastUsed);
        }

        @Override
        public MetadataTransientCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object key = input.readObject();
            Object value = input.readObject();
            PrivateMetadata internalMetadata = (PrivateMetadata)input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            return new MetadataTransientCacheEntry(key, value, internalMetadata, metadata, lastUsed);
        }

        @Override
        public Integer getId() {
            return Ids.METADATA_TRANSIENT_ENTRY;
        }

        @Override
        public Set<Class<? extends MetadataTransientCacheEntry>> getTypeClasses() {
            return Collections.singleton(MetadataTransientCacheEntry.class);
        }
    }
}

