/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.Ids;
import org.infinispan.distribution.ch.impl.AbstractConsistentHashFactory;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.distribution.ch.impl.ScatteredConsistentHash;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;

public class ScatteredConsistentHashFactory
extends AbstractConsistentHashFactory<ScatteredConsistentHash> {
    @Override
    public ScatteredConsistentHash create(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        if (numOwners != 1) {
            throw new IllegalArgumentException("The number of owners is supposed to be 1");
        }
        if (members.size() == 0) {
            throw new IllegalArgumentException("Can't construct a consistent hash without any members");
        }
        this.checkCapacityFactors(members, capacityFactors);
        Builder builder = new Builder(numSegments, members, capacityFactors);
        this.rebalanceBuilder(builder);
        return builder.build();
    }

    @Override
    public ScatteredConsistentHash fromPersistentState(ScopedPersistentState state) {
        String consistentHashClass = state.getProperty("consistentHash");
        if (!ScatteredConsistentHash.class.getName().equals(consistentHashClass)) {
            throw Log.CONTAINER.persistentConsistentHashMismatch(this.getClass().getName(), consistentHashClass);
        }
        return new ScatteredConsistentHash(state);
    }

    @Override
    public ScatteredConsistentHash updateMembers(ScatteredConsistentHash baseCH, List<Address> actualMembers, Map<Address, Float> actualCapacityFactors) {
        boolean sameCapacityFactors;
        if (actualMembers.size() == 0) {
            throw new IllegalArgumentException("Can't construct a consistent hash without any members");
        }
        this.checkCapacityFactors(actualMembers, actualCapacityFactors);
        boolean bl = actualCapacityFactors == null ? baseCH.getCapacityFactors() == null : (sameCapacityFactors = actualCapacityFactors.equals(baseCH.getCapacityFactors()));
        if (actualMembers.equals(baseCH.getMembers()) && sameCapacityFactors) {
            return baseCH;
        }
        Builder builder = new Builder(baseCH, actualMembers, actualCapacityFactors);
        return builder.build();
    }

    @Override
    public ScatteredConsistentHash rebalance(ScatteredConsistentHash baseCH) {
        Builder builder = new Builder(baseCH);
        this.rebalanceBuilder(builder);
        ScatteredConsistentHash balancedCH = builder.build();
        return balancedCH.equals(baseCH) ? baseCH : balancedCH;
    }

    @Override
    public ScatteredConsistentHash union(ScatteredConsistentHash dch1, ScatteredConsistentHash dch2) {
        return dch1.union(dch2);
    }

    protected void rebalanceBuilder(Builder builder) {
        this.addFirstOwner(builder);
        this.replacePrimaryOwners(builder);
        builder.setRebalanced(true);
    }

    private void addFirstOwner(Builder builder) {
        for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            Address newPrimary;
            if (builder.getPrimaryOwner(segment) != null || (newPrimary = this.findNewPrimaryOwner(builder, builder.getMembers(), null)) == null) continue;
            builder.addPrimaryOwner(segment, newPrimary);
        }
    }

    protected void replacePrimaryOwners(Builder builder) {
        boolean primaryOwnerReplaced = true;
        while (primaryOwnerReplaced) {
            Address worstNode = this.findWorstPrimaryOwner(builder, builder.getMembers());
            primaryOwnerReplaced = false;
            for (int segment = builder.getNumSegments() - 1; segment >= 0; --segment) {
                Address newPrimary;
                if (!Objects.equals(builder.getPrimaryOwner(segment), worstNode) || (newPrimary = this.findNewPrimaryOwner(builder, builder.getMembers(), worstNode)) == null) continue;
                builder.addPrimaryOwner(segment, newPrimary);
                primaryOwnerReplaced = true;
                worstNode = this.findWorstPrimaryOwner(builder, builder.getMembers());
            }
        }
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass();
    }

    public int hashCode() {
        return 4728;
    }

    protected static class Builder
    extends AbstractConsistentHashFactory.Builder {
        private final Address[] segmentOwners;
        private boolean isRebalanced;

        public Builder(int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
            super(new OwnershipStatistics(members), members, capacityFactors);
            this.segmentOwners = new Address[numSegments];
        }

        public Builder(ScatteredConsistentHash baseCH, List<Address> actualMembers, Map<Address, Float> actualCapacityFactors) {
            super(new OwnershipStatistics(baseCH, actualMembers), actualMembers, actualCapacityFactors);
            int numSegments = baseCH.getNumSegments();
            HashSet<Address> actualMembersSet = new HashSet<Address>(actualMembers);
            Address[] owners = new Address[numSegments];
            for (int segment = 0; segment < numSegments; ++segment) {
                Address owner = baseCH.locatePrimaryOwnerForSegment(segment);
                if (owner == null || !actualMembersSet.contains(owner)) continue;
                owners[segment] = owner;
            }
            this.segmentOwners = owners;
        }

        public Builder(ScatteredConsistentHash baseCH) {
            this(baseCH, baseCH.getMembers(), baseCH.getCapacityFactors());
        }

        public Builder(Builder other) {
            super(other);
            this.segmentOwners = Arrays.copyOf(other.segmentOwners, other.getNumSegments());
        }

        public int getNumSegments() {
            return this.segmentOwners.length;
        }

        public Address getPrimaryOwner(int segment) {
            return this.segmentOwners[segment];
        }

        public void addPrimaryOwner(int segment, Address newPrimaryOwner) {
            ++this.modCount;
            if (this.segmentOwners[segment] != null) {
                this.stats.decPrimaryOwned(this.segmentOwners[segment]);
            }
            this.segmentOwners[segment] = newPrimaryOwner;
            this.stats.incOwned(newPrimaryOwner);
            this.stats.incPrimaryOwned(newPrimaryOwner);
        }

        public ScatteredConsistentHash build() {
            return new ScatteredConsistentHash(this.segmentOwners.length, (List<Address>)this.members, this.capacityFactors, this.segmentOwners, this.isRebalanced);
        }

        public void setRebalanced(boolean isRebalanced) {
            this.isRebalanced = isRebalanced;
        }

        @Override
        public int getPrimaryOwned(Address node) {
            return this.stats.getPrimaryOwned(node);
        }

        public int getOwned(Address node) {
            return this.stats.getOwned(node);
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<ScatteredConsistentHashFactory> {
        @Override
        public void writeObject(ObjectOutput output, ScatteredConsistentHashFactory chf) throws IOException {
        }

        @Override
        public ScatteredConsistentHashFactory readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            return new ScatteredConsistentHashFactory();
        }

        @Override
        public Integer getId() {
            return Ids.SCATTERED_CONSISTENT_HASH_FACTORY;
        }

        @Override
        public Set<Class<? extends ScatteredConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(ScatteredConsistentHashFactory.class);
        }
    }
}

