/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntrySizeCalculator;
import org.infinispan.container.entries.PrimitiveEntrySizeCalculator;
import org.infinispan.container.impl.KeyValueMetadataSizeCalculator;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.impl.ComponentAlias;
import org.infinispan.marshall.core.WrappedByteArraySizeCalculator;

@DefaultFactoryFor(classes={KeyValueMetadataSizeCalculator.class})
public class SizeCalculatorFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        MemoryConfiguration memory = this.configuration.memory();
        if (memory.evictionStrategy().isEnabled() && memory.evictionType() == EvictionType.MEMORY) {
            StorageType type = memory.storageType();
            switch (type) {
                case BINARY: {
                    return CacheEntrySingleton.INSTANCE;
                }
                case OFF_HEAP: {
                    return ComponentAlias.of(OffHeapEntryFactory.class);
                }
            }
            throw new UnsupportedOperationException();
        }
        return (k, v, m4, im) -> 1L;
    }

    static class CacheEntrySingleton {
        static final CacheEntrySizeCalculator INSTANCE = new CacheEntrySizeCalculator(new WrappedByteArraySizeCalculator(new PrimitiveEntrySizeCalculator()));

        CacheEntrySingleton() {
        }
    }
}

