/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.CacheStream;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.marshall.core.Ids;
import org.infinispan.metadata.Metadata;

public final class CacheFilters {
    private CacheFilters() {
    }

    public static <K, V> Predicate<CacheEntry<K, V>> predicate(KeyValueFilter<? super K, ? super V> filter) {
        return new KeyValueFilterAsPredicate<K, V>(filter);
    }

    public static <K, V, C> Function<CacheEntry<K, V>, CacheEntry<K, C>> function(Converter<? super K, ? super V, C> converter) {
        return new ConverterAsCacheEntryFunction<K, V, C>(converter);
    }

    public static <K, V, C> Function<CacheEntry<K, V>, CacheEntry<K, C>> converterToFunction(KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return new FilterConverterAsCacheEntryFunction<K, V, C>(filterConverter);
    }

    public static <K, V> Predicate<CacheEntry<K, V>> notNullCacheEntryPredicate() {
        return NotNullCacheEntryPredicate.SINGLETON;
    }

    public static <K, V, C> CacheStream<K> filterAndConvertToKey(CacheStream<CacheEntry<K, V>> stream, KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return stream.flatMap(new FilterConverterAsKeyFunction<K, V>(filterConverter));
    }

    public static <K, V, C> CacheStream<C> filterAndConvertToValue(CacheStream<CacheEntry<K, V>> stream, KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return stream.flatMap(new FilterConverterAsValueFunction<K, V, C>(filterConverter));
    }

    public static <K, V, C> Stream<CacheEntry<K, C>> filterAndConvert(Stream<CacheEntry<K, V>> stream, KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return stream.map(CacheFilters.converterToFunction(filterConverter)).filter(CacheFilters.notNullCacheEntryPredicate());
    }

    public static <K, V, C> CacheStream<CacheEntry<K, C>> filterAndConvert(CacheStream<CacheEntry<K, V>> stream, KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return stream.map(CacheFilters.converterToFunction(filterConverter)).filter(CacheFilters.notNullCacheEntryPredicate());
    }

    @Scope(value=Scopes.NONE)
    static final class KeyValueFilterAsPredicate<K, V>
    implements Predicate<CacheEntry<K, V>> {
        private final KeyValueFilter<? super K, ? super V> filter;

        public KeyValueFilterAsPredicate(KeyValueFilter<? super K, ? super V> filter) {
            Objects.requireNonNull(filter);
            this.filter = filter;
        }

        @Override
        public boolean test(CacheEntry<K, V> kvCacheEntry) {
            return this.filter.accept(kvCacheEntry.getKey(), kvCacheEntry.getValue(), kvCacheEntry.getMetadata());
        }

        @Inject
        public void inject(ComponentRegistry registry) {
            registry.wireDependencies(this.filter);
        }
    }

    @Scope(value=Scopes.NONE)
    static final class ConverterAsCacheEntryFunction<K, V, C>
    implements Function<CacheEntry<K, V>, CacheEntry<K, C>> {
        private final Converter<? super K, ? super V, C> converter;
        private InternalEntryFactory factory;

        public ConverterAsCacheEntryFunction(Converter<? super K, ? super V, C> converter) {
            Objects.requireNonNull(converter);
            this.converter = converter;
        }

        @Inject
        public void inject(InternalEntryFactory factory, ComponentRegistry registry) {
            this.factory = factory;
            registry.wireDependencies(this.converter);
        }

        @Override
        public CacheEntry<K, C> apply(CacheEntry<K, V> kvCacheEntry) {
            Metadata metadata;
            C converted;
            K key = kvCacheEntry.getKey();
            V value = kvCacheEntry.getValue();
            if (value == (converted = this.converter.convert(key, value, metadata = kvCacheEntry.getMetadata()))) {
                return kvCacheEntry;
            }
            return this.factory.create(key, converted, metadata);
        }
    }

    @Scope(value=Scopes.NONE)
    static final class FilterConverterAsCacheEntryFunction<K, V, C>
    implements Function<CacheEntry<K, V>, CacheEntry<K, C>> {
        private final KeyValueFilterConverter<? super K, ? super V, C> filterConverter;
        private InternalEntryFactory factory;

        FilterConverterAsCacheEntryFunction(KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
            this.filterConverter = Objects.requireNonNull(filterConverter);
        }

        @Inject
        public void inject(InternalEntryFactory factory, ComponentRegistry registry) {
            this.factory = factory;
            registry.wireDependencies(this.filterConverter);
        }

        @Override
        public CacheEntry<K, C> apply(CacheEntry<K, V> kvCacheEntry) {
            Metadata metadata;
            V value;
            K key = kvCacheEntry.getKey();
            C converted = this.filterConverter.filterAndConvert(key, value = kvCacheEntry.getValue(), metadata = kvCacheEntry.getMetadata());
            if (converted == null) {
                return NullCacheEntry.getInstance();
            }
            if (value == converted) {
                return kvCacheEntry;
            }
            return this.factory.create(key, converted, metadata);
        }
    }

    @Scope(value=Scopes.NONE)
    static class NotNullCacheEntryPredicate<K, V>
    implements Predicate<CacheEntry<K, V>> {
        private static final NotNullCacheEntryPredicate SINGLETON = new NotNullCacheEntryPredicate();

        NotNullCacheEntryPredicate() {
        }

        @Override
        public boolean test(CacheEntry<K, V> kvCacheEntry) {
            return kvCacheEntry != null && kvCacheEntry != NullCacheEntry.getInstance();
        }
    }

    @Scope(value=Scopes.NONE)
    static final class FilterConverterAsKeyFunction<K, V>
    implements Function<CacheEntry<K, V>, Stream<K>> {
        private final KeyValueFilterConverter<? super K, ? super V, ?> converter;

        public FilterConverterAsKeyFunction(KeyValueFilterConverter<? super K, ? super V, ? super K> converter) {
            Objects.requireNonNull(converter);
            this.converter = converter;
        }

        @Inject
        public void inject(ComponentRegistry registry) {
            registry.wireDependencies(this.converter);
        }

        @Override
        public Stream<K> apply(CacheEntry<K, V> entry) {
            Object converted = this.converter.filterAndConvert(entry.getKey(), entry.getValue(), entry.getMetadata());
            if (converted == null) {
                return Stream.empty();
            }
            return Stream.of(entry.getKey());
        }
    }

    @Scope(value=Scopes.NONE)
    static final class FilterConverterAsValueFunction<K, V, C>
    implements Function<CacheEntry<K, V>, Stream<C>> {
        private final KeyValueFilterConverter<? super K, ? super V, C> converter;

        public FilterConverterAsValueFunction(KeyValueFilterConverter<? super K, ? super V, C> converter) {
            Objects.requireNonNull(converter);
            this.converter = converter;
        }

        @Inject
        public void inject(ComponentRegistry registry) {
            registry.wireDependencies(this.converter);
        }

        @Override
        public Stream<C> apply(CacheEntry<K, V> entry) {
            C converted = this.converter.filterAndConvert(entry.getKey(), entry.getValue(), entry.getMetadata());
            if (converted == null) {
                return Stream.empty();
            }
            return Stream.of(converted);
        }
    }

    public static final class CacheFiltersExternalizer
    implements AdvancedExternalizer<Object> {
        private static final int KEY_VALUE_FILTER_PREDICATE = 0;
        private static final int CONVERTER_FUNCTION = 1;
        private static final int FILTER_CONVERTER_FUNCTION = 2;
        private static final int FILTER_CONVERTER_VALUE_FUNCTION = 3;
        private static final int NOT_NULL_CACHE_ENTRY_PREDICATE = 4;
        private static final int FILTER_CONVERTER_KEY_FUNCTION = 5;
        private final Map<Class<?>, Integer> objects = new HashMap();

        public CacheFiltersExternalizer() {
            this.objects.put(KeyValueFilterAsPredicate.class, 0);
            this.objects.put(ConverterAsCacheEntryFunction.class, 1);
            this.objects.put(FilterConverterAsCacheEntryFunction.class, 2);
            this.objects.put(FilterConverterAsKeyFunction.class, 5);
            this.objects.put(FilterConverterAsValueFunction.class, 3);
            this.objects.put(NotNullCacheEntryPredicate.class, 4);
        }

        @Override
        public Set<Class<?>> getTypeClasses() {
            return Util.asSet(KeyValueFilterAsPredicate.class, ConverterAsCacheEntryFunction.class, FilterConverterAsCacheEntryFunction.class, FilterConverterAsKeyFunction.class, FilterConverterAsValueFunction.class, NotNullCacheEntryPredicate.class);
        }

        @Override
        public Integer getId() {
            return Ids.CACHE_FILTERS;
        }

        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            int number = this.objects.getOrDefault(object.getClass(), -1);
            output.writeByte(number);
            switch (number) {
                case 0: {
                    output.writeObject(((KeyValueFilterAsPredicate)object).filter);
                    break;
                }
                case 1: {
                    output.writeObject(((ConverterAsCacheEntryFunction)object).converter);
                    break;
                }
                case 2: {
                    output.writeObject(((FilterConverterAsCacheEntryFunction)object).filterConverter);
                    break;
                }
                case 5: {
                    output.writeObject(((FilterConverterAsKeyFunction)object).converter);
                    break;
                }
                case 3: {
                    output.writeObject(((FilterConverterAsValueFunction)object).converter);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type " + number + " is not supported!");
                }
            }
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int number = input.readUnsignedByte();
            switch (number) {
                case 0: {
                    return new KeyValueFilterAsPredicate((KeyValueFilter)input.readObject());
                }
                case 1: {
                    return new ConverterAsCacheEntryFunction((Converter)input.readObject());
                }
                case 2: {
                    return new FilterConverterAsCacheEntryFunction((KeyValueFilterConverter)input.readObject());
                }
                case 5: {
                    return new FilterConverterAsKeyFunction((KeyValueFilterConverter)input.readObject());
                }
                case 3: {
                    return new FilterConverterAsValueFunction((KeyValueFilterConverter)input.readObject());
                }
                case 4: {
                    return NotNullCacheEntryPredicate.SINGLETON;
                }
            }
            throw new IllegalArgumentException("Found invalid number " + number);
        }
    }
}

