/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BatchingInterceptor
extends DDAsyncInterceptor {
    @Inject
    BatchContainer batchContainer;
    @Inject
    TransactionManager transactionManager;
    @Inject
    InvocationContextFactory invocationContextFactory;
    private static final Log log = LogFactory.getLog(BatchingInterceptor.class);

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) {
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) {
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ) ? this.invokeNext(ctx, command) : this.handleDefault(ctx, command);
    }

    @Override
    public Object visitRemoveExpiredCommand(InvocationContext ctx, RemoveExpiredCommand command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
        return this.invokeNext(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Transaction tx;
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        if (this.transactionManager.getTransaction() != null || (tx = this.batchContainer.getBatchTransaction()) == null) {
            return this.invokeNext(ctx, command);
        }
        try {
            this.transactionManager.resume(tx);
            if (ctx.isInTxScope()) {
                Object object = this.invokeNext(ctx, command);
                return object;
            }
            log.tracef("Called with a non-tx invocation context: %s", (Object)ctx);
            InvocationContext txInvocationContext = this.invocationContextFactory.createInvocationContext(true, -1);
            Object object = this.invokeNext(txInvocationContext, command);
            return object;
        }
        finally {
            this.suspendTransaction();
        }
    }

    private void suspendTransaction() throws SystemException {
        if (this.transactionManager.getTransaction() != null && this.batchContainer.isSuspendTxAfterInvocation()) {
            this.transactionManager.suspend();
        }
    }
}

