/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.impl.AbstractIracLocalSiteInterceptor;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.responses.PrepareResponse;
import org.infinispan.util.IracUtils;

public class OptimisticTxIracLocalSiteInterceptor
extends AbstractIracLocalSiteInterceptor {
    private final InvocationSuccessAction<PrepareCommand> afterLocalPrepare = this::afterLocalTwoPhasePrepare;
    private final InvocationSuccessFunction<PrepareCommand> afterRemotePrepare = this::afterRemoteTwoPhasePrepare;

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        if (command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ)) {
            return this.visitNonTxDataWriteCommand(ctx, command);
        }
        Object key = command.getKey();
        if (OptimisticTxIracLocalSiteInterceptor.isIracState(command)) {
            this.setMetadataToCacheEntry(ctx.lookupEntry(key), command.getSegment(), command.getInternalMetadata(key).iracMetadata());
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        if (ctx.isOriginLocal()) {
            return this.invokeNextThenAccept(ctx, command, this.afterLocalPrepare);
        }
        return this.invokeNextThenApply(ctx, command, this.afterRemotePrepare);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) {
        if (ctx.isOriginLocal()) {
            return this.onLocalCommitCommand(ctx, command);
        }
        return this.onRemoteCommitCommand(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) {
        return this.invokeNext(ctx, command);
    }

    private void afterLocalTwoPhasePrepare(InvocationContext ctx, PrepareCommand command, Object rv) {
        if (this.isTraceEnabled()) {
            this.getLog().tracef("[IRAC] After successful local prepare for tx %s. Return Value: %s", (Object)command.getGlobalTransaction(), rv);
        }
        PrepareResponse prepareResponse = PrepareResponse.asPrepareResponse(rv);
        Iterator iterator = this.streamKeysFromModifications(command.getModifications()).iterator();
        HashMap<Integer, IracMetadata> segmentMetadata = new HashMap<Integer, IracMetadata>();
        while (iterator.hasNext()) {
            IracMetadata metadata;
            AbstractIracLocalSiteInterceptor.StreamData data = (AbstractIracLocalSiteInterceptor.StreamData)iterator.next();
            if (this.isPrimaryOwner(data)) {
                IracEntryVersion versionSeen = IracUtils.getIracVersionFromCacheEntry(ctx.lookupEntry(data.key));
                metadata = segmentMetadata.computeIfAbsent(data.segment, segment -> this.iracVersionGenerator.generateNewMetadata((int)segment, versionSeen));
            } else {
                metadata = segmentMetadata.computeIfAbsent(data.segment, prepareResponse::getIracMetadata);
            }
            assert (metadata != null) : "[IRAC] metadata is null after successful prepare! Data=" + String.valueOf(data);
            OptimisticTxIracLocalSiteInterceptor.updateCommandMetadata(data.key, data.command, metadata);
        }
    }

    private Object afterRemoteTwoPhasePrepare(InvocationContext ctx, PrepareCommand command, Object rv) {
        if (this.isTraceEnabled()) {
            this.getLog().tracef("[IRAC] After successful remote prepare for tx %s. Return Value: %s", (Object)command.getGlobalTransaction(), rv);
        }
        PrepareResponse rsp = PrepareResponse.asPrepareResponse(rv);
        Iterator iterator = this.streamKeysFromModifications(command.getModifications()).filter(this::isPrimaryOwner).distinct().iterator();
        HashMap<Integer, IracEntryVersion> maxVersionSeen = new HashMap<Integer, IracEntryVersion>();
        while (iterator.hasNext()) {
            AbstractIracLocalSiteInterceptor.StreamData data = (AbstractIracLocalSiteInterceptor.StreamData)iterator.next();
            IracEntryVersion versionSeen = IracUtils.getIracVersionFromCacheEntry(ctx.lookupEntry(data.key));
            if (versionSeen != null) {
                maxVersionSeen.merge(data.segment, versionSeen, IracEntryVersion::merge);
                continue;
            }
            maxVersionSeen.putIfAbsent(data.segment, null);
        }
        HashMap<Integer, IracMetadata> segmentMetadata = new HashMap<Integer, IracMetadata>();
        maxVersionSeen.forEach((segment, version) -> segmentMetadata.put((Integer)segment, this.iracVersionGenerator.generateNewMetadata((int)segment, (IracEntryVersion)version)));
        rsp.setNewIracMetadata(segmentMetadata);
        if (this.isTraceEnabled()) {
            this.getLog().tracef("[IRAC] After successful remote prepare for tx %s. New Return Value: %s", (Object)command.getGlobalTransaction(), (Object)rsp);
        }
        return rsp;
    }

    private Object onLocalCommitCommand(TxInvocationContext<?> ctx, CommitCommand command) {
        if (this.isTraceEnabled()) {
            this.getLog().tracef("[IRAC] On local Commit for tx %s", (Object)command.getGlobalTransaction());
        }
        Iterator iterator = this.streamKeysFromModifications(ctx.getModifications()).iterator();
        while (iterator.hasNext()) {
            AbstractIracLocalSiteInterceptor.StreamData data = (AbstractIracLocalSiteInterceptor.StreamData)iterator.next();
            IracMetadata metadata = data.command.getInternalMetadata(data.key).iracMetadata();
            command.addIracMetadata(data.segment, metadata);
            if (!this.isWriteOwner(data)) continue;
            this.setMetadataToCacheEntry(ctx.lookupEntry(data.key), data.segment, metadata);
        }
        return this.invokeNext(ctx, command);
    }

    private Object onRemoteCommitCommand(TxInvocationContext<?> context, CommitCommand command) {
        if (this.isTraceEnabled()) {
            this.getLog().tracef("[IRAC] On remote Commit for tx %s", (Object)command.getGlobalTransaction());
        }
        RemoteTxInvocationContext ctx = OptimisticTxIracLocalSiteInterceptor.asRemoteTxInvocationContext(context);
        Iterator iterator = this.streamKeysFromModifications(ctx.getModifications()).filter(this::isWriteOwner).iterator();
        while (iterator.hasNext()) {
            AbstractIracLocalSiteInterceptor.StreamData data = (AbstractIracLocalSiteInterceptor.StreamData)iterator.next();
            IracMetadata metadata = command.getIracMetadata(data.segment);
            this.setMetadataToCacheEntry(ctx.lookupEntry(data.key), data.segment, metadata);
        }
        return this.invokeNext(ctx, command);
    }

    private Stream<AbstractIracLocalSiteInterceptor.StreamData> streamKeysFromModifications(List<WriteCommand> mods) {
        return this.streamKeysFromModifications(mods.stream());
    }
}

