/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.eviction.impl.ActivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PassivationCacheLoaderInterceptor<K, V>
extends CacheLoaderInterceptor<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    DataOperationOrderer orderer;
    @Inject
    ActivationManager activationManager;

    @Override
    public CompletionStage<InternalCacheEntry<K, V>> loadAndStoreInDataContainer(InvocationContext ctx, Object key, int segment, FlagAffectedCommand cmd) {
        CompletableFuture<DataOperationOrderer.Operation> future = new CompletableFuture<DataOperationOrderer.Operation>();
        CompletionStage<DataOperationOrderer.Operation> delayStage = this.orderer.orderOn(key, future);
        CompletionStage retrievalStage = delayStage != null && !CompletionStages.isCompletedSuccessfully(delayStage) ? delayStage.thenCompose(ignore -> super.loadAndStoreInDataContainer(ctx, key, segment, cmd)) : super.loadAndStoreInDataContainer(ctx, key, segment, cmd);
        if (CompletionStages.isCompletedSuccessfully(retrievalStage)) {
            InternalCacheEntry ice = CompletionStages.join(retrievalStage);
            PassivationCacheLoaderInterceptor.activateAfterLoad(key, segment, this.orderer, this.activationManager, future, ice, null);
            return retrievalStage;
        }
        return retrievalStage.whenComplete((value, t2) -> PassivationCacheLoaderInterceptor.activateAfterLoad(key, segment, this.orderer, this.activationManager, future, value, t2));
    }

    static <K, V> void activateAfterLoad(Object key, int segment, DataOperationOrderer orderer, ActivationManager activationManager, CompletableFuture<DataOperationOrderer.Operation> future, InternalCacheEntry<K, V> value, Throwable t2) {
        if (value != null) {
            CompletionStage<Void> activationStage;
            if (log.isTraceEnabled()) {
                log.tracef("Activating key: %s - not waiting for response", value.getKey());
            }
            if (!CompletionStages.isCompletedSuccessfully(activationStage = activationManager.activateAsync(value.getKey(), segment))) {
                activationStage.whenComplete((ignore, throwable) -> {
                    if (throwable != null) {
                        log.warnf("Activation of key %s failed for some reason", (Object)t2);
                    }
                    orderer.completeOperation(key, future, DataOperationOrderer.Operation.READ);
                });
            } else {
                orderer.completeOperation(key, future, DataOperationOrderer.Operation.READ);
            }
        } else {
            orderer.completeOperation(key, future, DataOperationOrderer.Operation.READ);
        }
    }
}

