/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.KeyValueMetadataSizeCalculator;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionType;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionalExceptionEvictionInterceptor
extends DDAsyncInterceptor
implements InternalExpirationManager.ExpirationConsumer<Object, Object>,
Consumer<Iterable<InternalCacheEntry<Object, Object>>> {
    private static final Log log = LogFactory.getLog(TransactionalExceptionEvictionInterceptor.class);
    private final AtomicLong currentSize = new AtomicLong();
    private final ConcurrentMap<GlobalTransaction, Long> pendingSize = new ConcurrentHashMap<GlobalTransaction, Long>();
    private MemoryConfiguration memoryConfiguration;
    private InternalDataContainer<Object, Object> container;
    private DistributionManager dm;
    private long maxSize;
    private long minSize;
    private KeyValueMetadataSizeCalculator<Object, Object> calculator;
    private InternalExpirationManager<Object, Object> expirationManager;
    private InvocationSuccessAction<RemoveExpiredCommand> removeExpiredAccept = this::removeExpiredAccept;

    public long getCurrentSize() {
        return this.currentSize.get();
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getMinSize() {
        return this.minSize;
    }

    public long pendingTransactionCount() {
        return this.pendingSize.size();
    }

    @Inject
    public void inject(Configuration config, InternalDataContainer<Object, Object> dataContainer, KeyValueMetadataSizeCalculator<Object, Object> calculator, DistributionManager dm, InternalExpirationManager<Object, Object> expirationManager) {
        this.memoryConfiguration = config.memory();
        this.container = dataContainer;
        this.maxSize = config.memory().size();
        this.calculator = calculator;
        this.dm = dm;
        this.expirationManager = expirationManager;
    }

    @Start
    public void start() {
        if (this.memoryConfiguration.storageType() == StorageType.OFF_HEAP && this.memoryConfiguration.evictionType() == EvictionType.MEMORY) {
            this.minSize = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(2048L);
            this.currentSize.set(this.minSize);
        }
        this.container.addRemovalListener(this);
        this.expirationManager.addInternalListener(this);
    }

    @Stop
    public void stop() {
        this.container.removeRemovalListener(this);
        this.expirationManager.removeInternalListener(this);
    }

    @Override
    public void expired(Object key, Object value, Metadata metadata, PrivateMetadata privateMetadata) {
        if (value != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Key %s found to have expired", key);
            }
            this.adjustSize(-this.calculator.calculateSize(key, value, metadata, privateMetadata));
        }
    }

    @Override
    public void accept(Iterable<InternalCacheEntry<Object, Object>> entries) {
        long changeAmount = 0L;
        for (InternalCacheEntry<Object, Object> entry : entries) {
            changeAmount -= this.calculator.calculateSize(entry.getKey(), entry.getValue(), entry.getMetadata(), entry.getInternalMetadata());
        }
        if (changeAmount != 0L) {
            this.adjustSize(changeAmount);
        }
    }

    private boolean adjustSize(long amount) {
        long size;
        long targetSize;
        while ((targetSize = (size = this.currentSize.get()) + amount) <= this.maxSize) {
            if (!this.currentSize.compareAndSet(size, size + amount)) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Adjusted exception based size by %d to %d", amount, size + amount);
            }
            return true;
        }
        return false;
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        Object[] keys = command.getKeys();
        long changeAmount = 0L;
        for (Object key : keys) {
            InternalCacheEntry entry = this.container.peek(key);
            if (entry == null) continue;
            changeAmount -= this.calculator.calculateSize(key, entry.getValue(), entry.getMetadata(), entry.getInternalMetadata());
        }
        if (changeAmount != 0L) {
            this.adjustSize(changeAmount);
        }
        return super.visitInvalidateCommand(ctx, command);
    }

    @Override
    public Object visitRemoveExpiredCommand(InvocationContext ctx, RemoveExpiredCommand command) {
        Object key = command.getKey();
        if (ctx.isOriginLocal() && this.dm != null && !this.dm.getCacheTopology().getSegmentDistribution(command.getSegment()).isPrimary()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, this.removeExpiredAccept);
    }

    private void removeExpiredAccept(InvocationContext rCtx, RemoveExpiredCommand rCommand, Object rValue) {
        Object rKey = rCommand.getKey();
        if (rCommand.isSuccessful() && (this.dm == null || this.dm.getCacheTopology().getSegmentDistribution(rCommand.getSegment()).isWriteOwner())) {
            long changeAmount;
            MVCCEntry entry = (MVCCEntry)rCtx.lookupEntry(rKey);
            if (log.isTraceEnabled()) {
                log.tracef("Key %s was removed via expiration", rKey);
            }
            if ((changeAmount = -this.calculator.calculateSize(rKey, entry.getOldValue(), entry.getOldMetadata(), entry.getInternalMetadata())) != 0L && !this.adjustSize(changeAmount)) {
                throw Log.CONTAINER.containerFull(this.maxSize);
            }
        }
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (log.isTraceEnabled()) {
            log.tracef("Clear command encountered, resetting size to %d", this.minSize);
        }
        this.currentSize.set(this.minSize);
        return super.visitClearCommand(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        List<WriteCommand> modifications = ((AbstractCacheTransaction)ctx.getCacheTransaction()).getAllModifications();
        HashSet modifiedKeys = new HashSet();
        for (WriteCommand modification : modifications) {
            modifiedKeys.addAll(modification.getAffectedKeys());
        }
        long changeAmount = 0L;
        for (Object key : modifiedKeys) {
            InternalCacheEntry containerEntry;
            if (this.dm != null && !this.dm.getCacheTopology().isWriteOwner(key)) continue;
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry.isRemoved()) {
                containerEntry = this.container.peek(key);
                Object value = containerEntry != null ? (Object)containerEntry.getValue() : null;
                if (value == null) continue;
                if (log.isTraceEnabled()) {
                    log.tracef("Key %s was removed", key);
                }
                changeAmount -= this.calculator.calculateSize(key, value, entry.getMetadata(), entry.getInternalMetadata());
                continue;
            }
            containerEntry = this.container.peek(key);
            if (log.isTraceEnabled()) {
                log.tracef("Key %s was put into cache, replacing existing %s", key, (Object)(containerEntry != null ? 1 : 0));
            }
            changeAmount += this.calculator.calculateSize(key, entry.getValue(), entry.getMetadata(), entry.getInternalMetadata());
            if (containerEntry == null) continue;
            changeAmount -= this.calculator.calculateSize(key, containerEntry.getValue(), containerEntry.getMetadata(), containerEntry.getInternalMetadata());
        }
        if (changeAmount != 0L && !this.adjustSize(changeAmount)) {
            throw Log.CONTAINER.containerFull(this.maxSize);
        }
        if (!command.isOnePhaseCommit()) {
            this.pendingSize.put(ctx.getGlobalTransaction(), changeAmount);
        }
        return super.visitPrepareCommand(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        Long size = (Long)this.pendingSize.remove(ctx.getGlobalTransaction());
        if (size != null) {
            long newSize = this.currentSize.addAndGet(-size.longValue());
            if (log.isTraceEnabled()) {
                log.tracef("Rollback encountered subtracting exception size by %d to %d", (long)size, newSize);
            }
        }
        return super.visitRollbackCommand(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        this.pendingSize.remove(ctx.getGlobalTransaction());
        return super.visitCommitCommand(ctx, command);
    }
}

