/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.io.FileChunkMapper;
import org.infinispan.io.GridFile;
import org.infinispan.io.GridInputStream;
import org.infinispan.io.GridOutputStream;
import org.infinispan.io.ModularArithmetic;
import org.infinispan.io.ReadableGridFileChannel;
import org.infinispan.io.WritableGridFileChannel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Deprecated
public class GridFilesystem {
    private static final Log log = LogFactory.getLog(GridFilesystem.class);
    protected final Cache<String, byte[]> data;
    protected final Cache<String, GridFile.Metadata> metadata;
    protected final int defaultChunkSize;

    public GridFilesystem(Cache<String, byte[]> data, Cache<String, GridFile.Metadata> metadata, int defaultChunkSize) {
        if (metadata.getCacheConfiguration().clustering().cacheMode().isClustered() && !metadata.getCacheConfiguration().clustering().cacheMode().isSynchronous()) {
            log.warnGridFSMetadataCacheRequiresSync();
        }
        this.data = data;
        this.metadata = metadata;
        this.defaultChunkSize = ModularArithmetic.CANNOT_ASSUME_DENOM_IS_POWER_OF_TWO ? defaultChunkSize : Util.findNextHighestPowerOfTwo(defaultChunkSize);
    }

    public GridFilesystem(Cache<String, byte[]> data, Cache<String, GridFile.Metadata> metadata) {
        this(data, metadata, ModularArithmetic.CANNOT_ASSUME_DENOM_IS_POWER_OF_TWO ? 8000 : 8192);
    }

    public File getFile(String pathname) {
        return this.getFile(pathname, this.defaultChunkSize);
    }

    public File getFile(String pathname, int chunkSize) {
        return new GridFile(pathname, this.metadata, chunkSize, this);
    }

    public File getFile(String parent, String child) {
        return this.getFile(parent, child, this.defaultChunkSize);
    }

    public File getFile(String parent, String child, int chunkSize) {
        return new GridFile(parent, child, this.metadata, chunkSize, this);
    }

    public File getFile(File parent, String child) {
        return this.getFile(parent, child, this.defaultChunkSize);
    }

    public File getFile(File parent, String child, int chunkSize) {
        return new GridFile(parent, child, this.metadata, chunkSize, this);
    }

    public OutputStream getOutput(String pathname) throws IOException {
        return this.getOutput(pathname, false, this.defaultChunkSize);
    }

    public OutputStream getOutput(String pathname, boolean append) throws IOException {
        return this.getOutput(pathname, append, this.defaultChunkSize);
    }

    public OutputStream getOutput(String pathname, boolean append, int chunkSize) throws IOException {
        GridFile file = (GridFile)this.getFile(pathname, chunkSize);
        this.checkIsNotDirectory(file);
        this.createIfNeeded(file);
        return new GridOutputStream(file, append, this.data);
    }

    public OutputStream getOutput(GridFile file) throws IOException {
        this.checkIsNotDirectory(file);
        this.createIfNeeded(file);
        return new GridOutputStream(file, false, this.data);
    }

    private void checkIsNotDirectory(GridFile file) throws FileNotFoundException {
        if (file.isDirectory()) {
            throw new FileNotFoundException(String.valueOf(file) + " is a directory.");
        }
    }

    private void createIfNeeded(GridFile file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("creation of " + String.valueOf(file) + " failed");
        }
    }

    public InputStream getInput(String pathname) throws FileNotFoundException {
        GridFile file = (GridFile)this.getFile(pathname);
        this.checkFileIsReadable(file);
        return new GridInputStream(file, this.data);
    }

    private void checkFileIsReadable(GridFile file) throws FileNotFoundException {
        this.checkFileExists(file);
        this.checkIsNotDirectory(file);
    }

    private void checkFileExists(GridFile file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
    }

    public InputStream getInput(File file) throws FileNotFoundException {
        return file != null ? this.getInput(file.getPath()) : null;
    }

    public ReadableGridFileChannel getReadableChannel(String pathname) throws FileNotFoundException {
        GridFile file = (GridFile)this.getFile(pathname);
        this.checkFileIsReadable(file);
        return new ReadableGridFileChannel(file, this.data);
    }

    public WritableGridFileChannel getWritableChannel(String pathname) throws IOException {
        return this.getWritableChannel(pathname, false);
    }

    public WritableGridFileChannel getWritableChannel(String pathname, boolean append) throws IOException {
        return this.getWritableChannel(pathname, append, this.defaultChunkSize);
    }

    public WritableGridFileChannel getWritableChannel(String pathname, boolean append, int chunkSize) throws IOException {
        GridFile file = (GridFile)this.getFile(pathname, chunkSize);
        this.checkIsNotDirectory(file);
        this.createIfNeeded(file);
        return new WritableGridFileChannel(file, this.data, append);
    }

    void remove(String absolutePath) {
        if (absolutePath == null) {
            return;
        }
        GridFile.Metadata md = (GridFile.Metadata)this.metadata.get(absolutePath);
        if (md == null) {
            return;
        }
        int numChunks = md.getLength() / md.getChunkSize() + 1;
        for (int i = 0; i < numChunks; ++i) {
            this.data.remove(FileChunkMapper.getChunkKey(absolutePath, i));
        }
    }
}

