/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.marshall.core.impl.ClassToExternalizerMap;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class ExternalExternalizers {
    private static final Log log = LogFactory.getLog(ExternalExternalizers.class);

    private ExternalExternalizers() {
    }

    public static ClassToExternalizerMap load(GlobalConfiguration globalCfg) {
        return ExternalExternalizers.load(globalCfg, 0, Integer.MAX_VALUE);
    }

    public static ClassToExternalizerMap load(GlobalConfiguration globalCfg, int lowerBound, int upperBound) {
        ClassToExternalizerMap exts = new ClassToExternalizerMap(4, 0.375f);
        Map<Integer, AdvancedExternalizer<?>> cfgExts = globalCfg.serialization().advancedExternalizers();
        for (Map.Entry<Integer, AdvancedExternalizer<?>> config : cfgExts.entrySet()) {
            AdvancedExternalizer<Object> ext = config.getValue();
            Integer id = ext.getId();
            if (config.getKey() == null && id == null) {
                throw new CacheConfigurationException(String.format("No advanced externalizer identifier set for externalizer %s", ext.getClass().getName()));
            }
            if (config.getKey() != null) {
                id = config.getKey();
            }
            if (id < 0) {
                throw Log.CONTAINER.foreignExternalizerUsingNegativeId(ext, id);
            }
            if (id < lowerBound || id > upperBound) continue;
            Set<Class<?>> subTypes = ext.getTypeClasses();
            ForeignAdvancedExternalizer foreignExt = new ForeignAdvancedExternalizer(id, ext);
            for (Class<?> subType : subTypes) {
                exts.put(subType, foreignExt);
            }
        }
        return exts;
    }

    private static final class ForeignAdvancedExternalizer
    implements AdvancedExternalizer<Object> {
        final AdvancedExternalizer<Object> ext;
        final Integer id;

        private ForeignAdvancedExternalizer(int id, AdvancedExternalizer<Object> ext) {
            this.id = id;
            this.ext = ext;
        }

        @Override
        public Set<Class<?>> getTypeClasses() {
            return this.ext.getTypeClasses();
        }

        @Override
        public Integer getId() {
            return this.id;
        }

        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            this.ext.writeObject(output, object);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return this.ext.readObject(input);
        }

        public String toString() {
            return this.ext.getClass().getName();
        }
    }
}

