/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.FastCopyHashMap;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.util.ReadOnlySegmentAwareCollection;
import org.infinispan.marshall.core.Ids;

public class CollectionExternalizer
implements AdvancedExternalizer<Collection> {
    private static final int ARRAY_LIST = 0;
    private static final int LINKED_LIST = 1;
    private static final int SINGLETON_LIST = 2;
    private static final int EMPTY_LIST = 3;
    private static final int HASH_SET = 4;
    private static final int TREE_SET = 5;
    private static final int SINGLETON_SET = 6;
    private static final int SYNCHRONIZED_SET = 7;
    private static final int ARRAY_DEQUE = 8;
    private static final int READ_ONLY_SEGMENT_AWARE_COLLECTION = 9;
    private static final int ENTRY_SET = 10;
    private static final int EMPTY_SET = 11;
    private final Map<Class<?>, Integer> numbers = new HashMap(16);

    public CollectionExternalizer() {
        this.numbers.put(ArrayList.class, 0);
        this.numbers.put(CollectionExternalizer.getPrivateArrayListClass(), 0);
        this.numbers.put(CollectionExternalizer.getPrivateUnmodifiableListClass(), 0);
        this.numbers.put(LinkedList.class, 1);
        this.numbers.put(CollectionExternalizer.getPrivateSingletonListClass(), 2);
        this.numbers.put(CollectionExternalizer.getPrivateEmptyListClass(), 3);
        this.numbers.put(CollectionExternalizer.getPrivateEmptySetClass(), 11);
        this.numbers.put(ArrayDeque.class, 8);
        this.numbers.put(HashSet.class, 4);
        this.numbers.put(TreeSet.class, 5);
        this.numbers.put(CollectionExternalizer.getPrivateSingletonSetClass(), 6);
        this.numbers.put(CollectionExternalizer.getPrivateSynchronizedSetClass(), 7);
        this.numbers.put(CollectionExternalizer.getPrivateUnmodifiableSetClass(), 4);
        this.numbers.put(ReadOnlySegmentAwareCollection.class, 9);
        this.numbers.put(FastCopyHashMap.KeySet.class, 4);
        this.numbers.put(FastCopyHashMap.Values.class, 0);
        this.numbers.put(FastCopyHashMap.EntrySet.class, 10);
    }

    @Override
    public void writeObject(ObjectOutput output, Collection collection) throws IOException {
        int number = this.numbers.getOrDefault(collection.getClass(), -1);
        output.writeByte(number);
        switch (number) {
            case 0: 
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                MarshallUtil.marshallCollection(collection, output);
                break;
            }
            case 2: {
                output.writeObject(((List)collection).get(0));
                break;
            }
            case 6: {
                output.writeObject(collection.iterator().next());
                break;
            }
            case 5: {
                output.writeObject(((TreeSet)collection).comparator());
                MarshallUtil.marshallCollection(collection, output);
                break;
            }
            case 10: {
                MarshallUtil.marshallCollection(collection, output, (out, element) -> {
                    Map.Entry entry = (Map.Entry)element;
                    out.writeObject(entry.getKey());
                    out.writeObject(entry.getValue());
                });
            }
        }
    }

    @Override
    public Collection readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        switch (magicNumber) {
            case 0: {
                return MarshallUtil.unmarshallCollection(input, ArrayList::new);
            }
            case 1: {
                return MarshallUtil.unmarshallCollectionUnbounded(input, LinkedList::new);
            }
            case 2: {
                return Collections.singletonList(input.readObject());
            }
            case 3: {
                return Collections.emptyList();
            }
            case 4: {
                return MarshallUtil.unmarshallCollection(input, s2 -> new HashSet());
            }
            case 5: {
                Comparator comparator = (Comparator)input.readObject();
                return MarshallUtil.unmarshallCollection(input, s2 -> new TreeSet(comparator));
            }
            case 6: {
                return Collections.singleton(input.readObject());
            }
            case 7: {
                return Collections.synchronizedSet(MarshallUtil.unmarshallCollection(input, s2 -> new HashSet()));
            }
            case 8: {
                return MarshallUtil.unmarshallCollection(input, ArrayDeque::new);
            }
            case 9: {
                return MarshallUtil.unmarshallCollection(input, ArrayList::new);
            }
            case 10: {
                return MarshallUtil.unmarshallCollection(input, s2 -> new HashSet(), in -> new AbstractMap.SimpleEntry<Object, Object>(in.readObject(), in.readObject()));
            }
            case 11: {
                return Collections.emptySet();
            }
        }
        throw new IllegalStateException("Unknown Set type: " + magicNumber);
    }

    @Override
    public Integer getId() {
        return Ids.COLLECTIONS;
    }

    @Override
    public Set<Class<? extends Collection>> getTypeClasses() {
        Set<Class<? extends Collection>> typeClasses = Util.asSet(ArrayList.class, LinkedList.class, HashSet.class, TreeSet.class, ArrayDeque.class, ReadOnlySegmentAwareCollection.class, FastCopyHashMap.KeySet.class, FastCopyHashMap.Values.class, FastCopyHashMap.EntrySet.class);
        typeClasses.addAll(CollectionExternalizer.getSupportedPrivateClasses());
        return typeClasses;
    }

    public static Set<Class<Collection>> getSupportedPrivateClasses() {
        HashSet<Class> classNames = new HashSet<Class>(Arrays.asList(CollectionExternalizer.getPrivateArrayListClass(), CollectionExternalizer.getPrivateUnmodifiableListClass(), CollectionExternalizer.getPrivateEmptyListClass(), CollectionExternalizer.getPrivateEmptySetClass(), CollectionExternalizer.getPrivateSingletonListClass(), CollectionExternalizer.getPrivateSingletonSetClass(), CollectionExternalizer.getPrivateSynchronizedSetClass(), CollectionExternalizer.getPrivateUnmodifiableSetClass()));
        return Collections.unmodifiableSet(classNames);
    }

    private static Class<Collection> getPrivateArrayListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Arrays$ArrayList");
    }

    private static Class<Collection> getPrivateUnmodifiableListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$UnmodifiableRandomAccessList");
    }

    private static Class<Collection> getPrivateEmptyListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$EmptyList");
    }

    private static Class<Collection> getPrivateEmptySetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$EmptySet");
    }

    private static Class<Collection> getPrivateSingletonListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$SingletonList");
    }

    public static Class<Collection> getPrivateSingletonSetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$SingletonSet");
    }

    public static Class<Collection> getPrivateSynchronizedSetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$SynchronizedSet");
    }

    private static Class<Collection> getPrivateUnmodifiableSetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$UnmodifiableSet");
    }

    private static Class<Collection> getCollectionClass(String className) {
        return Util.loadClass(className, Collection.class.getClassLoader());
    }
}

