/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.persistence.sifs.SecurityActions;
import org.infinispan.persistence.sifs.pmem.PmemUtilWrapper;
import org.infinispan.util.logging.LogFactory;

public class FileProvider {
    private static final org.infinispan.persistence.sifs.Log log = LogFactory.getLog(FileProvider.class, org.infinispan.persistence.sifs.Log.class);
    private static final String REGEX_FORMAT = "^%s[0-9]+$";
    private static final boolean ATTEMPT_PMEM;
    private final File dataDir;
    private final int openFileLimit;
    private final ArrayBlockingQueue<Record> recordQueue;
    private final ConcurrentMap<Integer, Record> openFiles = new ConcurrentHashMap<Integer, Record>();
    private final AtomicInteger currentOpenFiles = new AtomicInteger(0);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<Integer> logFiles = new HashSet<Integer>();
    private final Set<FileIterator> iterators = ConcurrentHashMap.newKeySet();
    private final String prefix;
    private final int maxFileSize;
    private int nextFileId = 0;

    public FileProvider(Path dataDir, int openFileLimit, String prefix, int maxFileSize) {
        this.openFileLimit = openFileLimit;
        this.recordQueue = new ArrayBlockingQueue(openFileLimit);
        this.dataDir = dataDir.toFile();
        this.prefix = prefix;
        this.maxFileSize = maxFileSize;
        if (!SecurityActions.createDirectoryIfNeeded(this.dataDir)) {
            throw org.infinispan.util.logging.Log.PERSISTENCE.directoryCannotBeCreated(this.dataDir.getAbsolutePath());
        }
    }

    public boolean isLogFile(int fileId) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.logFiles.contains(fileId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Handle getFile(int fileId) throws IOException {
        Handle handle;
        Record newRecord;
        int open;
        block25: {
            Record record;
            this.lock.readLock().lock();
            while ((record = (Record)this.openFiles.get(fileId)) != null) {
                Record record2 = record;
                synchronized (record2) {
                    if (record.isOpen()) {
                        Handle handle2 = new Handle(record);
                        return handle2;
                    }
                }
            }
            break block25;
            finally {
                this.lock.readLock().unlock();
            }
        }
        while (!((open = this.currentOpenFiles.get()) >= this.openFileLimit ? this.tryCloseFile() : this.currentOpenFiles.compareAndSet(open, open + 1))) {
        }
        while (true) {
            FileChannel fileChannel;
            try {
                fileChannel = this.openChannel(fileId);
            }
            catch (FileNotFoundException e) {
                this.currentOpenFiles.decrementAndGet();
                log.debugf((Throwable)e, "File %d was not found", fileId);
                Handle handle3 = null;
                this.lock.readLock().unlock();
                return handle3;
            }
            newRecord = new Record(fileChannel, fileId);
            Record other = this.openFiles.putIfAbsent(fileId, newRecord);
            if (other == null) break;
            fileChannel.close();
            Record record = other;
            synchronized (record) {
                if (other.isOpen()) {
                    this.currentOpenFiles.decrementAndGet();
                    Handle handle4 = new Handle(other);
                    return handle4;
                }
            }
        }
        Object object = newRecord;
        synchronized (object) {
            if (!newRecord.isOpen()) {
                throw new IllegalStateException();
            }
            handle = new Handle(newRecord);
        }
        try {
            this.recordQueue.put(newRecord);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        object = handle;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileSize(int file) {
        this.lock.readLock().lock();
        try {
            if (this.logFiles.contains(file)) {
                long l = -1L;
                return l;
            }
            long l = this.newFile(file).length();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private String fileIdToString(int fileId) {
        return this.prefix + fileId;
    }

    File newFile(int fileId) {
        return new File(this.dataDir, this.fileIdToString(fileId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryCloseFile() throws IOException {
        Record removed;
        try {
            removed = this.recordQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Record record = removed;
        synchronized (record) {
            if (removed.isUsed()) {
                try {
                    this.recordQueue.put(removed);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } else {
                if (removed.isOpen()) {
                    removed.close();
                    this.openFiles.remove(removed.getFileId(), removed);
                }
                return true;
            }
        }
        return false;
    }

    protected FileChannel openChannel(int fileId) throws FileNotFoundException {
        return this.openChannel(this.newFile(fileId), false, true);
    }

    protected FileChannel openChannel(File file, boolean create, boolean readSharedMeadata) throws FileNotFoundException {
        FileChannel fileChannel;
        log.debugf("openChannel(%s)", (Object)file.getAbsolutePath());
        FileChannel fileChannel2 = fileChannel = ATTEMPT_PMEM ? PmemUtilWrapper.pmemChannelFor(file, this.maxFileSize, create, readSharedMeadata) : null;
        if (fileChannel == null) {
            fileChannel = create ? SecurityActions.createChannel(file) : SecurityActions.openFileChannel(file);
        }
        return fileChannel;
    }

    public Log getFileForLog() throws IOException {
        this.lock.writeLock().lock();
        try {
            while (true) {
                File f;
                if (SecurityActions.fileExists(f = this.newFile(this.nextFileId))) {
                    if (this.nextFileId == Integer.MAX_VALUE) {
                        this.nextFileId = 0;
                        continue;
                    }
                    ++this.nextFileId;
                    continue;
                }
                this.logFiles.add(this.nextFileId);
                for (FileIterator it : this.iterators) {
                    it.add(this.nextFileId);
                }
                FileChannel fileChannel = this.openChannel(f, true, false);
                if (fileChannel == null) {
                    fileChannel = new FileOutputStream(f).getChannel();
                }
                Log log = new Log(this.nextFileId, fileChannel);
                return log;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIterator<Integer> getFileIterator() {
        String regex = String.format(REGEX_FORMAT, this.prefix);
        this.lock.readLock().lock();
        try {
            HashSet<Integer> set = new HashSet<Integer>();
            for (String file : this.dataDir.list()) {
                if (!file.matches(regex)) continue;
                set.add(Integer.parseInt(file.substring(this.prefix.length())));
            }
            FileIterator iterator = new FileIterator(set.iterator());
            this.iterators.add(iterator);
            FileIterator fileIterator = iterator;
            return fileIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFiles() {
        String regex = String.format(REGEX_FORMAT, this.prefix);
        this.lock.readLock().lock();
        try {
            for (String file : this.dataDir.list()) {
                if (!file.matches(regex)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        this.lock.writeLock().lock();
        try {
            log.debug("Dropping all data");
            while (!(this.currentOpenFiles.get() <= 0 || this.tryCloseFile() && this.currentOpenFiles.decrementAndGet() == 0)) {
            }
            if (!this.recordQueue.isEmpty()) {
                throw new IllegalStateException();
            }
            if (!this.openFiles.isEmpty()) {
                throw new IllegalStateException();
            }
            File[] files = this.dataDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    Files.delete(file.toPath());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteFile(int fileId) {
        this.lock.readLock().lock();
        try {
            while (true) {
                Record newRecord = new Record(null, fileId);
                Record record = this.openFiles.putIfAbsent(fileId, newRecord);
                if (record == null) {
                    try {
                        newRecord.delete();
                    }
                    catch (IOException e) {
                        log.cannotCloseDeleteFile(fileId, e);
                    }
                    this.openFiles.remove(fileId, newRecord);
                    return;
                }
                Record record2 = record;
                synchronized (record2) {
                    if (this.openFiles.get(fileId) == record) {
                        try {
                            record.deleteOnClose();
                        }
                        catch (IOException e) {
                            log.cannotCloseDeleteFile(fileId, e);
                        }
                        return;
                    }
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void stop() {
        int open = this.currentOpenFiles.get();
        while (open > 0) {
            try {
                if (!this.tryCloseFile()) break;
                open = this.currentOpenFiles.decrementAndGet();
            }
            catch (IOException e) {
                log.cannotCloseFile(e);
            }
        }
        if (this.currentOpenFiles.get() != 0) {
            for (Map.Entry entry : this.openFiles.entrySet()) {
                log.debugf("File %d has %d open handles", (int)((Integer)entry.getKey()), ((Record)entry.getValue()).handleCount);
            }
        }
    }

    static {
        boolean attemptPmem = false;
        try {
            Class.forName("io.mashona.logwriting.PmemUtil");
            attemptPmem = true;
        }
        catch (ClassNotFoundException e) {
            log.debug("Persistent Memory not in classpath, not attempting");
        }
        ATTEMPT_PMEM = attemptPmem;
    }

    private class Record {
        private final int fileId;
        private FileChannel fileChannel;
        private int handleCount;
        private boolean deleteOnClose = false;

        private Record(FileChannel fileChannel, int fileId) {
            this.fileChannel = fileChannel;
            this.fileId = fileId;
        }

        FileChannel getFileChannel() {
            return this.fileChannel;
        }

        void increaseHandleCount() {
            ++this.handleCount;
        }

        void decreaseHandleCount() throws IOException {
            --this.handleCount;
            if (this.handleCount == 0 && this.deleteOnClose) {
                this.fileChannel.close();
                this.fileChannel = null;
                FileProvider.this.openFiles.remove(this.fileId, this);
                this.delete();
            }
        }

        boolean isOpen() {
            return this.fileChannel != null;
        }

        boolean isUsed() {
            return this.handleCount > 0;
        }

        public int getFileId() {
            return this.fileId;
        }

        public void close() throws IOException {
            this.fileChannel.close();
            this.fileChannel = null;
            if (this.deleteOnClose) {
                this.delete();
            }
        }

        public void delete() throws IOException {
            log.debugf("Deleting file %s", (Object)FileProvider.this.fileIdToString(this.fileId));
            Files.deleteIfExists(FileProvider.this.newFile(this.fileId).toPath());
        }

        public void deleteOnClose() throws IOException {
            if (this.handleCount == 0) {
                if (this.fileChannel != null) {
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
                FileProvider.this.openFiles.remove(this.fileId, this);
                this.delete();
            } else {
                log.debug("Marking file " + this.fileId + " for deletion");
                this.deleteOnClose = true;
            }
        }
    }

    public static final class Handle
    implements Closeable {
        private boolean usable = true;
        private final Record record;

        private Handle(Record record) {
            this.record = record;
            record.increaseHandleCount();
        }

        public int read(ByteBuffer buffer, long offset) throws IOException {
            if (!this.usable) {
                throw new IllegalStateException();
            }
            return this.record.getFileChannel().read(buffer, offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.usable = false;
            Record record = this.record;
            synchronized (record) {
                this.record.decreaseHandleCount();
            }
        }

        public long getFileSize() throws IOException {
            return this.record.fileChannel.size();
        }

        public int getFileId() {
            return this.record.getFileId();
        }
    }

    private class FileIterator
    implements CloseableIterator<Integer> {
        private final Iterator<Integer> diskFiles;
        private final ConcurrentLinkedQueue<Integer> addedFiles = new ConcurrentLinkedQueue();

        private FileIterator(Iterator<Integer> diskFiles) {
            this.diskFiles = diskFiles;
        }

        public void add(int file) {
            this.addedFiles.add(file);
        }

        @Override
        public void close() {
            FileProvider.this.iterators.remove(this);
        }

        @Override
        public boolean hasNext() {
            return this.diskFiles.hasNext() || !this.addedFiles.isEmpty();
        }

        @Override
        public Integer next() {
            return this.diskFiles.hasNext() ? this.diskFiles.next() : this.addedFiles.poll();
        }
    }

    public final class Log
    implements Closeable {
        public final int fileId;
        public final FileChannel fileChannel;

        public Log(int fileId, FileChannel fileChannel) {
            this.fileId = fileId;
            this.fileChannel = fileChannel;
        }

        @Override
        public void close() throws IOException {
            this.fileChannel.close();
            FileProvider.this.lock.writeLock().lock();
            try {
                FileProvider.this.logFiles.remove(this.fileId);
            }
            finally {
                FileProvider.this.lock.writeLock().unlock();
            }
        }
    }
}

