/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String maxNodeSizeLimitedToShort$str() {
        return "ISPN029001: Max size of index node (%d) is limited to 32767 bytes.";
    }

    @Override
    public final CacheConfigurationException maxNodeSizeLimitedToShort(int maxNodeSize) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.maxNodeSizeLimitedToShort$str(), maxNodeSize));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String minNodeSizeMustBeLessOrEqualToMax$str() {
        return "ISPN029002: Min size of index node (%d) must be less or equal to max size (%d).";
    }

    @Override
    public final CacheConfigurationException minNodeSizeMustBeLessOrEqualToMax(int minNodeSize, int maxNodeSize) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.minNodeSizeMustBeLessOrEqualToMax$str(), minNodeSize, maxNodeSize));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sizeCalculationInterrupted$str() {
        return "ISPN029003: Calculation of size has been interrupted.";
    }

    @Override
    public final PersistenceException sizeCalculationInterrupted(InterruptedException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.sizeCalculationInterrupted$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotTruncateIndex(IOException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.cannotTruncateIndex$str(), new Object[0]);
    }

    protected String cannotTruncateIndex$str() {
        return "ISPN029006: Cannot truncate index";
    }

    @Override
    public final void errorInIndexUpdater(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorInIndexUpdater$str(), new Object[0]);
    }

    protected String errorInIndexUpdater$str() {
        return "ISPN029007: Unexpected error in index updater thread.";
    }

    @Override
    public final void failedToCloseIndex(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToCloseIndex$str(), new Object[0]);
    }

    protected String failedToCloseIndex$str() {
        return "ISPN029008: Failed to close the index file.";
    }

    @Override
    public final void compactorFailed(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.compactorFailed$str(), new Object[0]);
    }

    protected String compactorFailed$str() {
        return "ISPN029009: Unexpected error in data compactor.";
    }

    @Override
    public final void cannotCloseDeleteFile(int fileId, IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.cannotCloseDeleteFile$str(), (Object)fileId);
    }

    protected String cannotCloseDeleteFile$str() {
        return "ISPN290010: Cannot close/delete data file %d.";
    }

    @Override
    public final void cannotCloseFile(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.cannotCloseFile$str(), new Object[0]);
    }

    protected String cannotCloseFile$str() {
        return "ISPN029011: Cannot close data file.";
    }

    protected String invalidCompactionThreshold$str() {
        return "ISPN029012: Compaction threshold (%f) should be between 0 (exclusively) and 1 (inclusively).";
    }

    @Override
    public final CacheConfigurationException invalidCompactionThreshold(double value) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.invalidCompactionThreshold$str(), value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotOpenIndex$str() {
        return "ISPN029013: Cannot open index on %s";
    }

    @Override
    public final PersistenceException cannotOpenIndex(String location, IOException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotOpenIndex$str(), location), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interruptedWhileStopping$str() {
        return "ISPN029014: Interrupted while stopping the store";
    }

    @Override
    public final PersistenceException interruptedWhileStopping(InterruptedException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.interruptedWhileStopping$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interruptedWhileClearing$str() {
        return "ISPN029015: Interrupted while pausing the index for clear.";
    }

    @Override
    public final PersistenceException interruptedWhileClearing(InterruptedException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.interruptedWhileClearing$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotClearIndex$str() {
        return "ISPN029016: Cannot clear/reopen index.";
    }

    @Override
    public final PersistenceException cannotClearIndex(IOException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotClearIndex$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotClearData$str() {
        return "ISPN029017: Cannot clear data directory.";
    }

    @Override
    public final PersistenceException cannotClearData(IOException e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotClearData$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyIsTooLong$str() {
        return "ISPN029018: The serialized form of key %s is too long (%d); with maxNodeSize=%d bytes you can use only keys serialized to at most %d bytes.";
    }

    @Override
    public final PersistenceException keyIsTooLong(Object key, int keyLength, int maxNodeSize, int maxKeyLength) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.keyIsTooLong$str(), key, keyLength, maxNodeSize, maxKeyLength));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotLoadKeyFromIndex$str() {
        return "ISPN029019: Cannot load key %s from index.";
    }

    @Override
    public final PersistenceException cannotLoadKeyFromIndex(Object key, Exception e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.cannotLoadKeyFromIndex$str(), key), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexLooksCorrupt$str() {
        return "ISPN029020: Index looks corrupt.";
    }

    @Override
    public final PersistenceException indexLooksCorrupt(Exception e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.indexLooksCorrupt$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void compactorEncounteredException(Throwable t2, int fileId) {
        this.log.logf(FQCN, Logger.Level.ERROR, t2, this.compactorEncounteredException$str(), (Object)fileId);
    }

    protected String compactorEncounteredException$str() {
        return "ISPN029021: File id %s encountered an exception while compacting, file may be orphaned";
    }

    @Override
    public final void compactedFileNotLongEnough(byte[] key, int file, long offset, long fileSize, EntryHeader record) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.compactedFileNotLongEnough$str(), Arrays.toString(key), file, offset, fileSize, record);
    }

    protected String compactedFileNotLongEnough$str() {
        return "ISPN029022: Compaction skipping a corrupted entry for key %s, at %s:%s|%s that doesn't have enough bytes for header %s";
    }
}

