/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoAdapter;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.ProtoSyntax;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.impl.Log;

public abstract class BaseProtoSchemaGenerator {
    private static final Log log = Log.LogFactory.getLog(BaseProtoSchemaGenerator.class);
    public static boolean generateSchemaDebugComments = false;
    public static boolean generateMarshallerDebugComments = false;
    protected final XTypeFactory typeFactory;
    protected final SerializationContext serializationContext;
    protected final String fileName;
    protected final String generator;
    protected final String packageName;
    protected final Set<XClass> classes;
    protected final boolean autoImportClasses;
    private final Set<XClass> knownClasses = new HashSet<XClass>();
    private final Set<String> imports = new HashSet<String>();
    private final Map<XClass, ProtoTypeMetadata> metadataByClass = new HashMap<XClass, ProtoTypeMetadata>();
    private final Map<String, ProtoTypeMetadata> metadataByTypeName = new HashMap<String, ProtoTypeMetadata>();
    private final ProtoSyntax syntax;

    protected BaseProtoSchemaGenerator(XTypeFactory typeFactory, SerializationContext serializationContext, String generator, String fileName, String packageName, Set<XClass> classes, boolean autoImportClasses, ProtoSyntax syntax) {
        if (fileName == null) {
            throw new ProtoSchemaBuilderException("fileName cannot be null");
        }
        this.typeFactory = typeFactory;
        this.serializationContext = serializationContext;
        this.generator = generator;
        this.fileName = fileName;
        this.packageName = packageName;
        this.classes = classes;
        this.autoImportClasses = autoImportClasses;
        this.syntax = syntax;
    }

    public ProtoSyntax syntax() {
        return this.syntax;
    }

    public String generateAndRegister() {
        ArrayList<ProtoTypeMetadata> meta;
        for (XClass xClass : this.classes) {
            this.collectKnownClasses(xClass);
        }
        for (XClass xClass : this.classes) {
            this.collectMetadata(this.makeTypeMetadata(xClass));
        }
        do {
            meta = new ArrayList<ProtoTypeMetadata>(this.metadataByClass.values());
            Iterator iterator = meta.iterator();
            while (iterator.hasNext()) {
                ProtoTypeMetadata m4 = (ProtoTypeMetadata)iterator.next();
                m4.scanMemberAnnotations();
            }
        } while (this.metadataByClass.size() != meta.size());
        for (XClass xClass : this.metadataByClass.keySet()) {
            ProtoMessageTypeMetadata outer;
            ProtoTypeMetadata m4 = this.metadataByClass.get(xClass);
            if (m4.isImported() || (outer = this.findOuterType(xClass)) == null) continue;
            m4.setOuterType(outer);
            outer.addInnerType(m4);
        }
        StringWriter sw = new StringWriter();
        IndentWriter indentWriter = new IndentWriter(sw);
        indentWriter.printf("// File name: %s\n", this.fileName);
        if (this.generator != null) {
            indentWriter.printf("// Generated from : %s\n", this.fileName);
        }
        if (generateSchemaDebugComments) {
            indentWriter.println("// Scanned classes:");
            for (ProtoTypeMetadata ptm : this.metadataByClass.values()) {
                if (ptm.isImported()) continue;
                indentWriter.append("//   ").append(ptm.getJavaClassName()).append('\n');
            }
        }
        indentWriter.printf("syntax = \"%s\";\n", new Object[]{this.syntax});
        if (this.packageName != null) {
            indentWriter.append("package ").append(this.packageName).append(";\n\n");
        }
        for (String dependency : this.imports) {
            indentWriter.append("import \"").append(dependency).append("\";\n");
        }
        for (XClass c : this.metadataByClass.keySet()) {
            ProtoTypeMetadata m5 = this.metadataByClass.get(c);
            if (m5.getOuterType() != null || m5.isImported()) continue;
            m5.generateProto(indentWriter, this.syntax);
        }
        String protoFile = sw.toString();
        if (log.isTraceEnabled()) {
            log.tracef("Generated proto file:\n%s", (Object)protoFile);
        }
        this.serializationContext.registerProtoFiles(FileDescriptorSource.fromString(this.fileName, protoFile));
        try {
            this.generateMarshallers();
        }
        catch (Exception e) {
            throw new ProtoSchemaBuilderException("Failed to generate marshaller implementation class", (Throwable)e);
        }
        return protoFile;
    }

    private ProtoMessageTypeMetadata findOuterType(XClass c) {
        ProtoTypeMetadata outer = null;
        for (XClass ec = c.getEnclosingClass(); ec != null; ec = ec.getEnclosingClass()) {
            if (ec.isEnum()) {
                throw new ProtoSchemaBuilderException("Classes defined inside an Enum are not allowed : " + c.getCanonicalName());
            }
            outer = this.metadataByClass.get(ec);
            if (outer != null) break;
        }
        return (ProtoMessageTypeMetadata)outer;
    }

    private void generateMarshallers() throws Exception {
        AbstractMarshallerCodeGenerator marshallerCodeGenerator = this.makeMarshallerCodeGenerator();
        for (XClass c : this.metadataByClass.keySet()) {
            ProtoTypeMetadata ptm = this.metadataByClass.get(c);
            if (ptm.isImported()) continue;
            marshallerCodeGenerator.generateMarshaller(this.serializationContext, ptm);
        }
    }

    public Set<XClass> getMarshalledClasses() {
        return this.metadataByClass.entrySet().stream().filter(e -> !((ProtoTypeMetadata)e.getValue()).isImported()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    protected abstract AbstractMarshallerCodeGenerator makeMarshallerCodeGenerator();

    protected ProtoTypeMetadata scanAnnotations(XClass javaType) {
        ProtoTypeMetadata protoTypeMetadata = this.metadataByClass.get(javaType);
        if (protoTypeMetadata != null) {
            return protoTypeMetadata;
        }
        protoTypeMetadata = this.importProtoTypeMetadata(javaType);
        if (protoTypeMetadata != null) {
            this.imports.add(protoTypeMetadata.getFileName());
        } else {
            protoTypeMetadata = this.makeTypeMetadata(javaType);
        }
        this.collectMetadata(protoTypeMetadata);
        return protoTypeMetadata;
    }

    protected abstract ProtoTypeMetadata importProtoTypeMetadata(XClass var1);

    protected ProtoTypeMetadata makeTypeMetadata(XClass javaType) {
        return javaType.isEnum() ? this.makeEnumTypeMetadata(javaType) : this.makeMessageTypeMetadata(javaType);
    }

    protected ProtoTypeMetadata makeEnumTypeMetadata(XClass javaType) {
        return new ProtoEnumTypeMetadata(javaType, this.getTargetClass(javaType));
    }

    protected ProtoTypeMetadata makeMessageTypeMetadata(XClass javaType) {
        return new ProtoMessageTypeMetadata(this, javaType, this.getTargetClass(javaType));
    }

    void collectMetadata(ProtoTypeMetadata protoTypeMetadata) {
        boolean isUnknownClass = this.isUnknownClass(protoTypeMetadata.getJavaClass());
        if (isUnknownClass && !this.autoImportClasses && !protoTypeMetadata.isImported()) {
            throw new ProtoSchemaBuilderException("Found a reference to class " + protoTypeMetadata.getJavaClassName() + " which was not added to the builder and 'autoImportClasses' is disabled.");
        }
        ProtoTypeMetadata existingByClass = this.metadataByClass.get(protoTypeMetadata.getJavaClass());
        if (existingByClass != null) {
            throw new ProtoSchemaBuilderException("Found a duplicate type definition. Java type '" + protoTypeMetadata.getJavaClassName() + "' is defined by " + protoTypeMetadata.getAnnotatedClassName() + " and also by " + existingByClass.getAnnotatedClassName());
        }
        String fullName = protoTypeMetadata.getFullName();
        ProtoTypeMetadata existingByName = this.metadataByTypeName.get(fullName);
        if (existingByName != null) {
            throw new ProtoSchemaBuilderException("Found a duplicate type definition. Type '" + fullName + "' is defined by " + protoTypeMetadata.getAnnotatedClassName() + " and also by " + existingByName.getAnnotatedClassName());
        }
        this.metadataByTypeName.put(fullName, protoTypeMetadata);
        this.metadataByClass.put(protoTypeMetadata.getJavaClass(), protoTypeMetadata);
    }

    protected boolean isUnknownClass(XClass c) {
        boolean isKnown;
        while (!(isKnown = this.knownClasses.contains(c)) && (c = c.getEnclosingClass()) != null) {
        }
        return !isKnown;
    }

    private void collectKnownClasses(XClass c) {
        XClass b = this.getAdapterFor(c);
        if (b != null) {
            this.knownClasses.add(b);
            return;
        }
        this.knownClasses.add(c);
        if (c.getSuperclass() != null) {
            this.collectKnownClasses(c.getSuperclass());
        }
        for (XClass i : c.getInterfaces()) {
            this.collectKnownClasses(i);
        }
    }

    protected XClass getAdapterFor(XClass annotatedClass) {
        ProtoAdapter protoAdapter = annotatedClass.getAnnotation(ProtoAdapter.class);
        if (protoAdapter != null) {
            XClass target = this.typeFactory.fromClass(protoAdapter.value());
            if (target == annotatedClass) {
                throw new ProtoSchemaBuilderException(annotatedClass.getName() + " has an invalid @ProtoAdapter annotation pointing to self");
            }
            return target;
        }
        return null;
    }

    protected XClass getTargetClass(XClass annotatedClass) {
        XClass target = this.getAdapterFor(annotatedClass);
        return target == null ? annotatedClass : target;
    }
}

