/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.types;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.infinispan.protostream.annotations.ProtoComment;

public final class DocumentationExtractor {
    public static final String PROTOSTREAM_ANNOTATIONS_PREFIX = "@org.infinispan.protostream.annotations";

    private static StringBuilder getDocumentation(ProtoComment[] annotations) {
        int end;
        int start;
        for (start = 0; start < annotations.length && annotations[start].value().isEmpty(); ++start) {
        }
        for (end = annotations.length; end > start && annotations[end - 1].value().isEmpty(); --end) {
        }
        StringBuilder sb = null;
        for (int i = start; i < end; ++i) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append('\n');
            }
            sb.append(annotations[i].value());
        }
        return sb;
    }

    public static String getDocumentation(Element element, boolean fullyQualified) {
        StringBuilder docs = DocumentationExtractor.getDocumentation((ProtoComment[])element.getAnnotationsByType(ProtoComment.class));
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String s2 = annotationMirror.toString();
            docs = DocumentationExtractor.annotationToString(docs, s2, fullyQualified);
        }
        return docs != null ? docs.toString() : null;
    }

    public static String getDocumentation(Field f, boolean fullyQualified) {
        StringBuilder docs = DocumentationExtractor.getDocumentation((ProtoComment[])f.getAnnotationsByType(ProtoComment.class));
        return DocumentationExtractor.getDocumentation(docs, f.getAnnotations(), fullyQualified);
    }

    public static String getDocumentation(Class<?> clazz, boolean fullyQualified) {
        StringBuilder docs = DocumentationExtractor.getDocumentation((ProtoComment[])clazz.getAnnotationsByType(ProtoComment.class));
        return DocumentationExtractor.getDocumentation(docs, clazz.getAnnotations(), fullyQualified);
    }

    public static String getDocumentation(Method method, boolean fullyQualified) {
        StringBuilder docs = DocumentationExtractor.getDocumentation((ProtoComment[])method.getAnnotationsByType(ProtoComment.class));
        return DocumentationExtractor.getDocumentation(docs, method.getAnnotations(), fullyQualified);
    }

    private static String getDocumentation(StringBuilder docs, Annotation[] annotations, boolean fullyQualified) {
        for (Annotation annotation : annotations) {
            String s2 = annotation.toString();
            docs = DocumentationExtractor.annotationToString(docs, s2, fullyQualified);
        }
        return docs != null ? docs.toString() : null;
    }

    private static StringBuilder annotationToString(StringBuilder docs, String s2, boolean fullyQualified) {
        if (!s2.startsWith(PROTOSTREAM_ANNOTATIONS_PREFIX)) {
            if (docs == null) {
                docs = new StringBuilder();
            } else {
                docs.append('\n');
            }
            if (fullyQualified) {
                docs.append(s2);
            } else {
                docs.append('@');
                int i = s2.indexOf(40);
                i = i > 0 ? s2.lastIndexOf(46, i) : s2.lastIndexOf(46);
                docs.append(i > 0 ? s2.substring(i + 1) : s2.substring(1));
            }
        }
        return docs;
    }
}

