/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.EnumContainer;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FieldContainer;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.MapDescriptor;
import org.infinispan.protostream.descriptors.MessageContainer;
import org.infinispan.protostream.descriptors.OneOfDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.descriptors.OptionContainer;
import org.infinispan.protostream.descriptors.ReservedContainer;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.SparseBitSet;

public final class Descriptor
extends AnnotatedDescriptorImpl
implements GenericDescriptor {
    private Integer typeId;
    private final List<Option> options;
    private final List<FieldDescriptor> fields;
    private final List<OneOfDescriptor> oneofs;
    private final List<Descriptor> nestedMessageTypes;
    private final List<EnumDescriptor> nestedEnumTypes;
    private final Map<Integer, FieldDescriptor> fieldsByNumber;
    private final Map<String, FieldDescriptor> fieldsByName;
    private FileDescriptor fileDescriptor;
    private Descriptor containingType;
    private final SparseBitSet reservedNumbers;
    private final Set<String> reservedNames;

    private Descriptor(Builder builder) {
        super(builder.name, builder.fullName, builder.documentation);
        this.options = List.copyOf(builder.options);
        this.fields = List.copyOf(builder.fields);
        this.oneofs = List.copyOf(builder.oneOfs);
        this.reservedNumbers = builder.reservedNumbers;
        this.reservedNames = Set.copyOf(builder.reservedNames);
        int totalFields = this.fields.size() + this.oneofs.size();
        this.fieldsByNumber = new HashMap<Integer, FieldDescriptor>(totalFields);
        this.fieldsByName = new HashMap<String, FieldDescriptor>(totalFields);
        this.addFields(builder.fields);
        for (OneOfDescriptor oneOfDescriptor : this.oneofs) {
            this.addFields(oneOfDescriptor.getFields());
            oneOfDescriptor.setContainingMessage(this);
        }
        this.nestedMessageTypes = List.copyOf(builder.nestedMessageTypes);
        this.nestedEnumTypes = List.copyOf(builder.nestedEnumTypes);
        for (Descriptor descriptor : this.nestedMessageTypes) {
            descriptor.setContainingType(this);
        }
        for (EnumDescriptor enumDescriptor : this.nestedEnumTypes) {
            enumDescriptor.setContainingType(this);
        }
    }

    private void addFields(List<? extends FieldDescriptor> fields) {
        for (FieldDescriptor fieldDescriptor : fields) {
            if (this.reservedNames.contains(fieldDescriptor.getName())) {
                throw Log.LOG.reservedName(fieldDescriptor.getName(), this.fullName);
            }
            if (this.reservedNumbers.get(fieldDescriptor.getNumber())) {
                throw Log.LOG.reservedNumber(fieldDescriptor.getNumber(), fieldDescriptor.getName(), this.fullName);
            }
            FieldDescriptor existing = this.fieldsByNumber.put(fieldDescriptor.getNumber(), fieldDescriptor);
            if (existing != null) {
                throw new IllegalStateException("Field number " + fieldDescriptor.getNumber() + " has already been used in \"" + this.fullName + "\" by field \"" + existing.getName() + "\".");
            }
            existing = this.fieldsByName.put(fieldDescriptor.getName(), fieldDescriptor);
            if (existing != null) {
                throw new IllegalStateException("Field \"" + fieldDescriptor.getName() + "\" is already defined in \"" + this.fullName + "\" with numbers " + existing.getNumber() + " and " + fieldDescriptor.getNumber() + ".");
            }
            fieldDescriptor.setContainingMessage(this);
        }
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public List<OneOfDescriptor> getOneOfs() {
        return this.oneofs;
    }

    public List<Descriptor> getNestedTypes() {
        return this.nestedMessageTypes;
    }

    public List<EnumDescriptor> getEnumTypes() {
        return this.nestedEnumTypes;
    }

    public FieldDescriptor findFieldByNumber(int number) {
        return this.fieldsByNumber.get(number);
    }

    public FieldDescriptor findFieldByName(String name) {
        return this.fieldsByName.get(name);
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
        for (FieldDescriptor fieldDescriptor : this.fields) {
            fieldDescriptor.setFileDescriptor(fileDescriptor);
        }
        for (Descriptor descriptor : this.nestedMessageTypes) {
            descriptor.setFileDescriptor(fileDescriptor);
        }
        for (EnumDescriptor enumDescriptor : this.nestedEnumTypes) {
            enumDescriptor.setFileDescriptor(fileDescriptor);
        }
        this.typeId = (Integer)this.getProcessedAnnotation("TypeId");
        if (this.typeId != null && this.typeId < 0) {
            throw new DescriptorParserException("TypeId cannot be negative");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return this.fullName.equals(that.fullName);
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    @Override
    public Integer getTypeId() {
        return this.typeId;
    }

    @Override
    public Descriptor getContainingType() {
        return this.containingType;
    }

    private void setContainingType(Descriptor containingType) {
        this.containingType = containingType;
        for (Descriptor descriptor : this.nestedMessageTypes) {
            descriptor.setContainingType(this);
        }
        for (EnumDescriptor enumDescriptor : this.nestedEnumTypes) {
            enumDescriptor.setContainingType(this);
        }
    }

    @Override
    protected AnnotationConfiguration getAnnotationConfig(AnnotationElement.Annotation annotation) {
        AnnotationConfiguration annotationConfiguration = this.getAnnotationsConfig().annotations().get(annotation.getName());
        if (annotationConfiguration == null) {
            return null;
        }
        if (annotation.getPackageName() != null && !annotation.getPackageName().equals(annotationConfiguration.packageName())) {
            return null;
        }
        for (AnnotationElement.AnnotationTarget t2 : annotationConfiguration.target()) {
            if (t2 != AnnotationElement.AnnotationTarget.MESSAGE) continue;
            return annotationConfiguration;
        }
        throw new DescriptorParserException("Annotation '" + annotation + "' cannot be applied to message types.");
    }

    public String toString() {
        return "Descriptor{fullName=" + this.getFullName() + "}";
    }

    public boolean isReserved(String name) {
        return this.reservedNames.contains(name);
    }

    public boolean isReserved(int number) {
        return this.reservedNumbers.get(number);
    }

    public static final class Builder
    implements OptionContainer<Builder>,
    FieldContainer<Builder>,
    EnumContainer<Builder>,
    MessageContainer<Builder>,
    ReservedContainer<Builder> {
        private String name;
        private String fullName;
        private List<Option> options = new ArrayList<Option>();
        private List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        private List<OneOfDescriptor> oneOfs = new ArrayList<OneOfDescriptor>();
        private List<Descriptor> nestedMessageTypes = new ArrayList<Descriptor>();
        private List<EnumDescriptor> nestedEnumTypes = new ArrayList<EnumDescriptor>();
        private String documentation;
        private final SparseBitSet reservedNumbers = new SparseBitSet();
        private final Set<String> reservedNames = new HashSet<String>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder withFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withFields(List<FieldDescriptor> fields) {
            this.fields = fields;
            return this;
        }

        public Builder withOneOfs(List<OneOfDescriptor> oneofs) {
            this.oneOfs = oneofs;
            return this;
        }

        public Builder withNestedTypes(List<Descriptor> nestedMessageTypes) {
            this.nestedMessageTypes = nestedMessageTypes;
            return this;
        }

        public Builder withEnumTypes(List<EnumDescriptor> nestedEnumTypes) {
            this.nestedEnumTypes = nestedEnumTypes;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        @Override
        public Builder addField(FieldDescriptor.Builder field) {
            this.fields.add(field.build());
            return this;
        }

        public Builder addMap(MapDescriptor.Builder map) {
            this.fields.add(map.build());
            return this;
        }

        public Builder addOneOf(OneOfDescriptor.Builder oneOf) {
            this.oneOfs.add(oneOf.build());
            return this;
        }

        @Override
        public Builder addOption(Option option) {
            this.options.add(option);
            return this;
        }

        @Override
        public Builder addEnum(EnumDescriptor.Builder enumDescriptor) {
            this.nestedEnumTypes.add(enumDescriptor.withFullName(FileDescriptor.fullName(this.fullName, enumDescriptor.getName())).build());
            return this;
        }

        @Override
        public Builder addMessage(Builder message) {
            this.nestedMessageTypes.add(message.withFullName(FileDescriptor.fullName(this.fullName, message.getName())).build());
            return this;
        }

        @Override
        public Builder addReserved(int number) {
            this.reservedNumbers.set(number);
            return this;
        }

        @Override
        public Builder addReserved(int from, int to) {
            this.reservedNumbers.set((long)from, to + 1);
            return this;
        }

        @Override
        public Builder addReserved(String name) {
            this.reservedNames.add(name);
            return this;
        }

        public Descriptor build() {
            return new Descriptor(this);
        }
    }
}

