/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.MalformedProtobufException;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.exception.ProtoStreamException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="IPROTO")
public interface Log
extends BasicLogger {
    public static final Log LOG = Logger.getMessageLogger(Log.class, "org.infinispan.PROTOSTREAM");

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Field %s was read out of sequence leading to sub-optimal performance", id=1)
    public void fieldReadOutOfSequence(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Field %s was written out of sequence and will lead to sub-optimal read performance", id=2)
    public void fieldWriteOutOfSequence(String var1);

    @Message(value="Input data ended unexpectedly in the middle of a field. The message is corrupt.", id=3)
    public MalformedProtobufException messageTruncated(@Cause Throwable var1);

    default public MalformedProtobufException messageTruncated() {
        return this.messageTruncated(null);
    }

    @Message(value="Encountered a malformed varint.", id=4)
    public MalformedProtobufException malformedVarint();

    @Message(value="Encountered a length delimited field with negative length.", id=5)
    public MalformedProtobufException negativeLength();

    @Message(value="Protobuf message appears to be larger than the configured limit. The message is possibly corrupt.", id=6)
    public MalformedProtobufException globalLimitExceeded();

    @Message(value="Ran out of buffer space", id=7)
    public IOException outOfWriteBufferSpace(@Cause Throwable var1);

    @Message(value="The nested message depth appears to be larger than the configured limit of '%s'.It is possible that the entity to marshall with type '%s' can have some circular dependencies.", id=8)
    public ProtoStreamException maxNestedMessageDepth(int var1, Class<?> var2);

    @Message(value="Not a repeatable field: %s#%s", id=9)
    public IllegalStateException notRepeatableField(String var1, String var2);

    @Message(value="Name '%s' is reserved on `%s`", id=10)
    public IllegalArgumentException reservedName(String var1, String var2);

    @Message(value="Number %d used by '%s' is reserved on '%s'", id=11)
    public IllegalArgumentException reservedNumber(int var1, String var2, String var3);

    @Message(value="Unsupported protocol buffers syntax '%s'", id=12)
    public IllegalArgumentException unsupportedSyntax(FileDescriptor.Syntax var1);

    @Message(value="Error while parsing '%s': %s", id=13)
    public DescriptorParserException parserException(String var1, String var2);

    @Message(value="The type %s of field %s of %s should not be abstract.", id=14)
    public ProtoSchemaBuilderException abstractType(String var1, String var2, String var3);

    @Message(value="The field named '%s' of %s is a member of the '%s' oneof which collides with an existing field or oneof.", id=15)
    public ProtoSchemaBuilderException oneofCollision(String var1, String var2, String var3);

    @Message(value="The field named '%s' of %s cannot be marked repeated or required since it is member of the '%s' oneof.", id=16)
    public ProtoSchemaBuilderException oneofRepeatedOrRequired(String var1, String var2, String var3);

    @Message(value="Abstract classes are not allowed: '%s'", id=17)
    public ProtoSchemaBuilderException abstractClassNotAllowed(String var1);

    @Message(value="Local or anonymous classes are not allowed. The class '%s' must be instantiable using an accessible no-argument constructor.", id=18)
    public ProtoSchemaBuilderException localOrAnonymousClass(String var1);

    @Message(value="Non-static inner classes are not allowed. The class '%s' must be instantiable using an accessible no-argument constructor.", id=19)
    public ProtoSchemaBuilderException nonStaticInnerClass(String var1);

    @Message(value="Invalid default value for field '%s' of Java type %s from class %s: the %s enum must have a 0 value", id=20)
    public ProtoSchemaBuilderException noDefaultEnum(String var1, String var2, String var3, String var4);

    @Message(value="@ProtoFactory annotated %s signature mismatch. The first parameter is expected to be of type 'int' : %s", id=21)
    public ProtoSchemaBuilderException factorySignatureMismatch(String var1, String var2);

    @Message(value="@ProtoFactory annotated %s signature mismatch. Expected %d parameters but found %d : %s", id=22)
    public ProtoSchemaBuilderException factorySignatureMismatch(String var1, int var2, int var3, String var4);

    @Message(value="@ProtoFactory annotated %s signature mismatch. The parameter '%s' does not match any field : %s", id=23)
    public ProtoSchemaBuilderException factorySignatureMismatch(String var1, String var2, String var3);

    @Message(value="@ProtoFactory annotated %s signature mismatch: %s. The parameter '%s' does not match the type from the field definition.", id=24)
    public ProtoSchemaBuilderException factorySignatureMismatchType(String var1, String var2, String var3);

    @Message(value="Found more than one @ProtoFactory annotated method / constructor : %s", id=25)
    public ProtoSchemaBuilderException multipleFactories(String var1);

    @Message(value="@ProtoFactory annotated constructor must not be private: %s", id=26)
    public ProtoSchemaBuilderException privateFactory(String var1);

    @Message(value="@ProtoFactory annotated method must be static: %s", id=27)
    public ProtoSchemaBuilderException nonStaticFactory(String var1);

    @Message(value="@ProtoFactory annotated method has wrong return type: %s", id=28)
    public ProtoSchemaBuilderException wrongFactoryReturnType(String var1);

    @Message(value="Value `%s` on enum `%s` must be annotated with @ProtoEnumValue", id=29)
    public ProtoSchemaBuilderException explicitEnumValueAnnotations(String var1, String var2);

    public static class LogFactory {
        public static Log getLog(Class<?> clazz) {
            return Logger.getMessageLogger(Log.class, clazz.getName());
        }
    }
}

