/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumContainer;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldContainer;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.Label;
import org.infinispan.protostream.descriptors.MapDescriptor;
import org.infinispan.protostream.descriptors.MessageContainer;
import org.infinispan.protostream.descriptors.OneOfDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.descriptors.OptionContainer;
import org.infinispan.protostream.descriptors.ReservedContainer;
import org.infinispan.protostream.impl.parser.ParseException;
import org.infinispan.protostream.impl.parser.ProtoParserConstants;
import org.infinispan.protostream.impl.parser.ProtoParserTokenManager;
import org.infinispan.protostream.impl.parser.ProtostreamProtoParser;
import org.infinispan.protostream.impl.parser.SimpleCharStream;
import org.infinispan.protostream.impl.parser.Token;

public class ProtoParser
implements ProtoParserConstants {
    static final Pattern DECOMMENTIFY = Pattern.compile("(\\s*\\*+\\/|^([ \\t]*\\/\\*+|[ \\t]*\\*[ \\t]*))", 8);
    private Configuration configuration;
    private FileDescriptor.Syntax syntax = FileDescriptor.Syntax.PROTO2;
    public ProtoParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[41];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    static FileDescriptor parse(String fileName, Reader reader, Configuration configuration) throws ParseException {
        ProtoParser parser = new ProtoParser(reader);
        parser.configuration = configuration;
        FileDescriptor.Builder f = parser.Proto();
        f.withName(fileName);
        return f.build();
    }

    static void appendComment(StringBuilder s2) {
        String comment = DECOMMENTIFY.matcher(s2).replaceAll("").trim();
        ProtostreamProtoParser.comments.get().append(comment).append('\n');
    }

    static String comment() {
        StringBuilder s2 = ProtostreamProtoParser.comments.get();
        ProtostreamProtoParser.comments.remove();
        return s2.toString();
    }

    static String unquote(String s2) {
        return s2.charAt(0) == '\"' ? s2.substring(1, s2.length() - 1) : s2;
    }

    static String unquote(Token t2) {
        return ProtoParser.unquote(t2.image);
    }

    static int toInt(Token t2) {
        return Integer.parseInt(t2.image);
    }

    public final FileDescriptor.Builder Proto() throws ParseException {
        FileDescriptor.Builder f;
        block14: {
            f = new FileDescriptor.Builder();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    this.Syntax(f);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                }
            }
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: 
                    case 24: 
                    case 25: 
                    case 28: 
                    case 29: 
                    case 31: 
                    case 32: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 25: {
                        this.Import(f);
                        continue block13;
                    }
                    case 28: {
                        this.Package(f);
                        continue block13;
                    }
                    case 24: {
                        this.Option(f);
                        continue block13;
                    }
                    case 29: 
                    case 31: 
                    case 32: {
                        this.TopLevelDef(f);
                        continue block13;
                    }
                    case 8: {
                        this.EmptyStatement();
                        continue block13;
                    }
                }
                break;
            }
            this.jj_la1[2] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
        return f;
    }

    public final void EmptyStatement() throws ParseException {
        this.jj_consume_token(8);
    }

    public final void TopLevelDef(FileDescriptor.Builder f) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 31: {
                this.Message(f);
                break;
            }
            case 32: {
                this.Enum(f);
                break;
            }
            case 29: {
                this.Service(f);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Syntax(FileDescriptor.Builder f) throws ParseException {
        ProtoParser.comment();
        this.jj_consume_token(21);
        this.jj_consume_token(41);
        Token t2 = this.jj_consume_token(7);
        this.jj_consume_token(8);
        this.syntax = FileDescriptor.Syntax.fromString(ProtoParser.unquote(t2));
        f.withSyntax(this.syntax);
    }

    public final void Import(FileDescriptor.Builder f) throws ParseException {
        boolean pub = false;
        ProtoParser.comment();
        this.jj_consume_token(25);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 26: 
            case 27: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        break block0;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        pub = true;
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        Token t2 = this.jj_consume_token(7);
        this.jj_consume_token(8);
        if (pub) {
            f.addPublicDependency(ProtoParser.unquote(t2));
        } else {
            f.addDependency(ProtoParser.unquote(t2));
        }
    }

    public final void Package(FileDescriptor.Builder f) throws ParseException {
        ProtoParser.comment();
        this.jj_consume_token(28);
        Token t2 = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42 -> this.jj_consume_token(42);
            case 43 -> this.jj_consume_token(43);
            default -> {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        this.jj_consume_token(8);
        f.withPackageName(t2.image);
    }

    public final void Option(OptionContainer o) throws ParseException {
        this.jj_consume_token(24);
        String name = this.OptionName();
        this.jj_consume_token(41);
        String value = this.Constant();
        this.jj_consume_token(8);
        o.addOption(new Option(name, value));
    }

    public final void Enum(EnumContainer c) throws ParseException {
        EnumDescriptor.Builder e = new EnumDescriptor.Builder().withDocumentation(ProtoParser.comment());
        this.jj_consume_token(32);
        String name = this.EnumName();
        this.EnumBody(e);
        c.addEnum(e.withName(name));
    }

    public final void EnumBody(EnumDescriptor.Builder e) throws ParseException {
        this.jj_consume_token(13);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    this.Option(e);
                    break;
                }
                case 42: {
                    this.EnumField(e);
                    break;
                }
                case 8: {
                    this.EmptyStatement();
                    break;
                }
                case 35: {
                    this.Reserved(e);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: 
                case 24: 
                case 35: 
                case 42: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[8] = this.jj_gen;
        this.jj_consume_token(14);
    }

    public final void EnumField(EnumDescriptor.Builder e) throws ParseException {
        EnumValueDescriptor.Builder v = new EnumValueDescriptor.Builder().withDocumentation(ProtoParser.comment());
        Token t2 = this.jj_consume_token(42);
        v.withName(t2.image);
        this.jj_consume_token(41);
        t2 = this.jj_consume_token(39);
        v.withTag(ProtoParser.toInt(t2));
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                this.EnumValueOption(v);
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 10: {
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(10);
                    this.EnumValueOption(v);
                }
                this.jj_consume_token(18);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        e.addValue(v);
    }

    public final void EnumValueOption(OptionContainer c) throws ParseException {
        String name = this.OptionName();
        this.jj_consume_token(41);
        String value = this.Constant();
        c.addOption(new Option(name, value));
    }

    public final void Field(FieldContainer c) throws ParseException {
        FieldDescriptor.Builder f = new FieldDescriptor.Builder().withDocumentation(ProtoParser.comment());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                Token label = this.jj_consume_token(23);
                f.withLabel(Label.fromString(label.image, this.syntax));
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        String type = this.Type();
        String name = this.FieldName();
        this.jj_consume_token(41);
        Token number = this.jj_consume_token(39);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                this.FieldOptions(f);
                this.jj_consume_token(18);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(8);
        c.addField(f.withTypeName(type).withName(name).withNumber(ProtoParser.toInt(number)));
    }

    public final void FieldOptions(OptionContainer c) throws ParseException {
        this.FieldOption(c);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(10);
            this.FieldOption(c);
        }
    }

    public final void FieldOption(OptionContainer c) throws ParseException {
        Token name = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42 -> this.jj_consume_token(42);
            case 43 -> this.jj_consume_token(43);
            default -> {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        this.jj_consume_token(41);
        String value = this.Constant();
        c.addOption(new Option(name.image, value));
    }

    public final void MapField(Descriptor.Builder c) throws ParseException {
        MapDescriptor.Builder m4 = new MapDescriptor.Builder();
        m4.withDocumentation(ProtoParser.comment());
        this.jj_consume_token(34);
        this.jj_consume_token(19);
        String keyType = this.Type();
        this.jj_consume_token(10);
        String valueType = this.Type();
        this.jj_consume_token(20);
        String name = this.MapName();
        this.jj_consume_token(41);
        Token number = this.jj_consume_token(39);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                this.FieldOptions(m4);
                this.jj_consume_token(18);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        this.jj_consume_token(8);
        m4.withKeyTypeName(keyType).withValueTypeName(valueType).withName(name).withNumber(ProtoParser.toInt(number));
        c.addMap(m4);
    }

    public final void Message(MessageContainer c) throws ParseException {
        Descriptor.Builder m4 = new Descriptor.Builder().withDocumentation(ProtoParser.comment());
        this.jj_consume_token(31);
        String name = this.MessageName();
        m4.withName(name).withFullName(FileDescriptor.fullName(c.getFullName(), name));
        this.MessageBody(m4);
        c.addMessage(m4);
    }

    public final void MessageBody(Descriptor.Builder m4) throws ParseException {
        block14: {
            this.jj_consume_token(13);
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: 
                    case 23: 
                    case 24: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 42: 
                    case 43: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: 
                    case 42: 
                    case 43: {
                        this.Field(m4);
                        continue block13;
                    }
                    case 32: {
                        this.Enum(m4);
                        continue block13;
                    }
                    case 31: {
                        this.Message(m4);
                        continue block13;
                    }
                    case 24: {
                        this.Option(m4);
                        continue block13;
                    }
                    case 33: {
                        this.OneOf(m4);
                        continue block13;
                    }
                    case 34: {
                        this.MapField(m4);
                        continue block13;
                    }
                    case 35: {
                        this.Reserved(m4);
                        continue block13;
                    }
                    case 8: {
                        this.EmptyStatement();
                        continue block13;
                    }
                }
                break;
            }
            this.jj_la1[17] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(14);
    }

    public final void MessageValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                this.Message(null);
                this.jj_consume_token(14);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                this.Message(null);
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void OneOf(Descriptor.Builder m4) throws ParseException {
        OneOfDescriptor.Builder o = new OneOfDescriptor.Builder().withDocumentation(ProtoParser.comment());
        this.jj_consume_token(33);
        String name = this.OneOfName();
        this.jj_consume_token(13);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    this.Option(m4);
                    break;
                }
                case 42: 
                case 43: {
                    this.OneOfField(o);
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: 
                case 42: 
                case 43: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[20] = this.jj_gen;
        this.jj_consume_token(14);
        m4.addOneOf(o.withName(name));
    }

    public final void OneOfField(OneOfDescriptor.Builder o) throws ParseException {
        FieldDescriptor.Builder f = new FieldDescriptor.Builder().withLabel(Label.ONE_OF).withDocumentation(ProtoParser.comment());
        String type = this.Type();
        String name = this.FieldName();
        this.jj_consume_token(41);
        Token number = this.jj_consume_token(39);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                this.FieldOptions(f);
                this.jj_consume_token(18);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.jj_consume_token(8);
        o.addField(f.withTypeName(type).withName(name).withNumber(ProtoParser.toInt(number)));
    }

    public final String Type() throws ParseException {
        Token t2 = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42 -> this.jj_consume_token(42);
            case 43 -> this.jj_consume_token(43);
            default -> {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        return t2.image;
    }

    public final void Reserved(ReservedContainer c) throws ParseException {
        this.jj_consume_token(35);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 39: {
                    this.Ranges(c);
                    break;
                }
                case 7: {
                    this.ReservedNames(c);
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: 
                case 39: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(8);
    }

    public final void Ranges(ReservedContainer c) throws ParseException {
        this.Range(c);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(10);
            this.Range(c);
        }
    }

    public final void Range(ReservedContainer c) throws ParseException {
        Token end = null;
        Token start = this.jj_consume_token(39);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        end = this.jj_consume_token(39);
                        break block0;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        break block0;
                    }
                }
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        if (end == null) {
            c.addReserved(ProtoParser.toInt(start));
        } else {
            c.addReserved(ProtoParser.toInt(start), ProtoParser.toInt(end));
        }
    }

    public final void ReservedNames(ReservedContainer c) throws ParseException {
        Token name = this.jj_consume_token(7);
        c.addReserved(ProtoParser.unquote(name));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(10);
            name = this.jj_consume_token(7);
            c.addReserved(ProtoParser.unquote(name));
        }
    }

    public final void Rpc() throws ParseException {
        this.jj_consume_token(38);
        this.RpcName();
        this.jj_consume_token(15);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        this.NamedType();
        this.jj_consume_token(16);
        this.jj_consume_token(36);
        this.jj_consume_token(15);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        this.NamedType();
        this.jj_consume_token(16);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 24: {
                            this.Option(null);
                            break;
                        }
                        case 8: {
                            this.EmptyStatement();
                            break;
                        }
                        default: {
                            this.jj_la1[31] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 8: 
                        case 24: {
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(14);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Service(FileDescriptor.Builder f) throws ParseException {
        this.jj_consume_token(29);
        this.ServiceName();
        this.jj_consume_token(13);
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    this.Option(f);
                    break;
                }
                case 38: {
                    this.Rpc();
                    break;
                }
                case 8: {
                    this.EmptyStatement();
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: 
                case 24: 
                case 38: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[35] = this.jj_gen;
        this.jj_consume_token(14);
    }

    public final String Constant() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                String s2 = this.FullIdent();
                return s2;
            }
            case 39: {
                Token t2 = this.jj_consume_token(39);
                return t2.image;
            }
            case 40: {
                Token t3 = this.jj_consume_token(40);
                return t3.image;
            }
            case 7: {
                Token t4 = this.jj_consume_token(7);
                return ProtoParser.unquote(t4);
            }
            case 22: {
                Token t5 = this.jj_consume_token(22);
                return t5.image;
            }
            case 13: 
            case 19: {
                this.MessageValue();
                return null;
            }
        }
        this.jj_la1[36] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String FullIdent() throws ParseException {
        StringBuilder s2 = new StringBuilder();
        Token t2 = this.jj_consume_token(42);
        s2.append(t2.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(11);
            t2 = this.jj_consume_token(42);
            s2.append(t2.image);
        }
        return s2.toString();
    }

    public final String MessageName() throws ParseException {
        Token t2 = this.jj_consume_token(42);
        return t2.image;
    }

    public final String EnumName() throws ParseException {
        Token t2 = this.jj_consume_token(42);
        return t2.image;
    }

    public final String FieldName() throws ParseException {
        Token t2 = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42 -> this.jj_consume_token(42);
            case 23 -> this.jj_consume_token(23);
            case 22 -> this.jj_consume_token(22);
            case 32 -> this.jj_consume_token(32);
            case 25 -> this.jj_consume_token(25);
            case 34 -> this.jj_consume_token(34);
            case 30 -> this.jj_consume_token(30);
            case 31 -> this.jj_consume_token(31);
            case 33 -> this.jj_consume_token(33);
            case 24 -> this.jj_consume_token(24);
            case 28 -> this.jj_consume_token(28);
            case 26 -> this.jj_consume_token(26);
            case 35 -> this.jj_consume_token(35);
            case 36 -> this.jj_consume_token(36);
            case 29 -> this.jj_consume_token(29);
            case 37 -> this.jj_consume_token(37);
            case 21 -> this.jj_consume_token(21);
            case 27 -> this.jj_consume_token(27);
            default -> {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        return t2.image;
    }

    public final String OneOfName() throws ParseException {
        Token t2 = this.jj_consume_token(42);
        return t2.image;
    }

    public final String OptionName() throws ParseException {
        Token t2 = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42 -> this.jj_consume_token(42);
            case 43 -> this.jj_consume_token(43);
            default -> {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        return t2.image;
    }

    public final String MapName() throws ParseException {
        Token t2 = this.jj_consume_token(42);
        return t2.image;
    }

    public final String ServiceName() throws ParseException {
        Token t2 = this.jj_consume_token(42);
        return t2.image;
    }

    public final String RpcName() throws ParseException {
        Token t2 = this.jj_consume_token(42);
        return t2.image;
    }

    public final String NamedType() throws ParseException {
        StringBuilder sb = new StringBuilder();
        Token t2 = this.jj_consume_token(42);
        sb.append(t2.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(11);
            t2 = this.jj_consume_token(42);
            sb.append('.').append(t2.image);
        }
        return sb.toString();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x200000, -1291845376, -1291845376, -1610612736, 0xC000000, 0xC000000, 0, 0x1000100, 0x1000100, 1024, 131072, 0x800000, 131072, 1024, 0, 131072, -2122317568, -2122317568, 532480, 0x1000000, 0x1000000, 131072, 0, 128, 128, 1024, 0x40000000, 4096, 1024, 0, 0, 0x1000100, 0x1000100, 8448, 0x1000100, 0x1000100, 4726912, 2048, -2097152, 0, 2048};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 1, 1, 1, 0, 0, 3072, 1032, 1032, 0, 0, 0, 0, 0, 3072, 0, 3087, 3087, 0, 3072, 3072, 0, 3072, 128, 128, 0, 128, 0, 0, 32, 32, 0, 0, 0, 64, 64, 1408, 0, 1087, 3072, 0};
    }

    public ProtoParser(InputStream stream) {
        this(stream, null);
    }

    public ProtoParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ProtoParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ProtoParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ProtoParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ProtoParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ProtoParser(ProtoParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ProtoParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t2 = this.token;
        for (int i = 0; i < index; ++i) {
            t2 = t2.next != null ? t2.next : (t2.next = this.token_source.getNextToken());
        }
        return t2;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[44];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 41; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 44; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ProtoParser.jj_la1_init_0();
        ProtoParser.jj_la1_init_1();
    }
}

