/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser;

import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.parser.ParseException;
import org.infinispan.protostream.impl.parser.ProtoParser;
import org.infinispan.protostream.impl.parser.Token;
import org.infinispan.protostream.impl.parser.TokenMgrError;

public final class ProtostreamProtoParser {
    static ThreadLocal<StringBuilder> comments = ThreadLocal.withInitial(StringBuilder::new);
    private final Configuration configuration;

    public ProtostreamProtoParser(Configuration configuration) {
        this.configuration = configuration;
    }

    public Map<String, FileDescriptor> parse(FileDescriptorSource fileDescriptorSource) throws DescriptorParserException {
        Map<String, String> input = fileDescriptorSource.getFiles();
        LinkedHashMap<String, FileDescriptor> fileDescriptorMap = new LinkedHashMap<String, FileDescriptor>(input.size());
        for (Map.Entry<String, String> entry : input.entrySet()) {
            String fileName = entry.getKey();
            try {
                FileDescriptor fileDescriptor = ProtoParser.parse(fileName, new StringReader(entry.getValue()), this.configuration);
                fileDescriptor.setConfiguration(this.configuration);
                fileDescriptorMap.put(fileName, fileDescriptor);
            }
            catch (DescriptorParserException e) {
                this.reportParsingError(fileDescriptorSource, fileDescriptorMap, fileName, e);
            }
            catch (RuntimeException | TokenMgrError e) {
                this.reportParsingError(fileDescriptorSource, fileDescriptorMap, fileName, Log.LOG.parserException(fileName, e.getMessage()));
            }
            catch (ParseException e) {
                Token next = e.currentToken.next;
                String s2 = String.format("Syntax error in %s at %d:%d: unexpected label: %s", fileName, next.beginLine, next.endColumn, next.image);
                this.reportParsingError(fileDescriptorSource, fileDescriptorMap, fileName, new DescriptorParserException(s2, e));
            }
        }
        return fileDescriptorMap;
    }

    private void reportParsingError(FileDescriptorSource fileDescriptorSource, Map<String, FileDescriptor> fileDescriptorMap, String fileName, DescriptorParserException dpe) {
        if (fileDescriptorSource.getProgressCallback() == null) {
            throw dpe;
        }
        FileDescriptor stub = new FileDescriptor.Builder().withName(fileName).withParsingException(dpe).build();
        stub.setConfiguration(this.configuration);
        fileDescriptorMap.put(fileName, stub);
        fileDescriptorSource.getProgressCallback().handleError(fileName, dpe);
    }
}

