/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.infinispan.protostream.schema.CommentContainer;
import org.infinispan.protostream.schema.Field;
import org.infinispan.protostream.schema.Message;
import org.infinispan.protostream.schema.OptionContainer;
import org.infinispan.protostream.schema.Schema;
import org.infinispan.protostream.schema.Type;

public class OneOf {
    private final String name;
    private final String fullName;
    private final Map<String, Field> fields;
    private final List<String> comments;

    OneOf(Builder builder) {
        this.name = builder.name;
        this.fullName = builder.getFullName();
        this.fields = builder.fields.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((FieldBuilder)e.getValue()).create()));
        this.comments = List.copyOf(builder.comments);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public static class Builder
    implements CommentContainer<Builder> {
        private final Message.Builder message;
        private final String name;
        private final Map<String, FieldBuilder> fields = new HashMap<String, FieldBuilder>();
        private final List<String> comments = new ArrayList<String>();

        Builder(Message.Builder message, String name) {
            this.message = message;
            this.name = name;
        }

        public FieldBuilder addOneOfField(Type type, String name, int number) {
            Objects.requireNonNull(type, "type must not be null");
            Objects.requireNonNull(name, "name must not be null");
            this.checkDuplicate(name);
            FieldBuilder field = new FieldBuilder(this, type, name, number);
            this.fields.put(name, field);
            return field;
        }

        @Override
        public Builder addComment(String comment) {
            Objects.requireNonNull(comment, "comment must not be null");
            this.comments.add(comment.trim());
            return this;
        }

        OneOf create() {
            return new OneOf(this);
        }

        public String getFullName() {
            return this.message.getFullName() + "." + this.name;
        }

        private void checkDuplicate(String name) {
            if (this.fields.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate field name " + name);
            }
        }
    }

    public static class FieldBuilder
    implements OptionContainer<FieldBuilder>,
    CommentContainer<FieldBuilder> {
        private final Builder parent;
        private final Field.Builder builder;

        FieldBuilder(Builder parent, Type type, String name, int number) {
            this.parent = parent;
            this.builder = new Field.Builder(parent.message, type, name, number, false);
        }

        public FieldBuilder addOneOfField(Type type, String name, int number) {
            return this.parent.addOneOfField(type, name, number);
        }

        public Field create() {
            return this.builder.create();
        }

        @Override
        public FieldBuilder addComment(String comment) {
            this.builder.addComment(comment);
            return this;
        }

        @Override
        public Schema build() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFullName() {
            return this.parent.getFullName();
        }

        @Override
        public FieldBuilder addOption(String name, Object value) {
            this.builder.addOption(name, value);
            return null;
        }
    }
}

