/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Ids;
import org.reactivestreams.Publisher;

public class PublisherTransformers {
    private PublisherTransformers() {
    }

    public static <I> Function<Publisher<I>, Publisher<I>> identity() {
        return IdentityTransformer.INSTANCE;
    }

    private static final class IdentityTransformer<I>
    implements Function<Publisher<I>, Publisher<I>> {
        private static final IdentityTransformer INSTANCE = new IdentityTransformer();

        private IdentityTransformer() {
        }

        @Override
        public Publisher<I> apply(Publisher<I> publisher) {
            return publisher;
        }
    }

    public static final class PublisherTransformersExternalizer
    implements AdvancedExternalizer<Object> {
        private static final ExternalizerId[] VALUES = ExternalizerId.values();
        private final Map<Class<?>, ExternalizerId> objects = new HashMap();

        public PublisherTransformersExternalizer() {
            for (ExternalizerId id : ExternalizerId.values()) {
                this.objects.put(id.marshalledClass, id);
            }
        }

        @Override
        public Set<Class<?>> getTypeClasses() {
            return this.objects.keySet();
        }

        @Override
        public Integer getId() {
            return Ids.PUBLISHER_TRANSFORMERS;
        }

        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            ExternalizerId id = this.objects.get(object.getClass());
            if (id == null) {
                throw new IllegalArgumentException("Unsupported class " + String.valueOf(object.getClass()) + " was provided!");
            }
            output.writeByte(id.ordinal());
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int number = input.readUnsignedByte();
            ExternalizerId[] ids = VALUES;
            if (number < 0 || number >= ids.length) {
                throw new IllegalArgumentException("Found invalid number " + number);
            }
            ExternalizerId id = ids[number];
            switch (id.ordinal()) {
                case 0: {
                    return IdentityTransformer.INSTANCE;
                }
            }
            throw new IllegalArgumentException("ExternalizerId not supported: " + String.valueOf((Object)id));
        }

        static enum ExternalizerId {
            IDENTITY_TRANSFORMER(IdentityTransformer.class);

            private final Class<?> marshalledClass;

            private ExternalizerId(Class<?> marshalledClass) {
                this.marshalledClass = marshalledClass;
            }
        }
    }
}

