/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.LongConsumer;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.XSiteAsyncAckListener;

public class AggregateBackupResponse
implements BackupResponse {
    final Collection<BackupResponse> responses = new ArrayList<BackupResponse>(2);

    public AggregateBackupResponse(BackupResponse onePcResponse, BackupResponse twoPcResponse) {
        if (onePcResponse != null) {
            this.responses.add(onePcResponse);
        }
        if (twoPcResponse != null) {
            this.responses.add(twoPcResponse);
        }
    }

    @Override
    public void waitForBackupToFinish() throws Exception {
        for (BackupResponse br : this.responses) {
            br.waitForBackupToFinish();
        }
    }

    @Override
    public Map<String, Throwable> getFailedBackups() {
        HashMap<String, Throwable> result = new HashMap<String, Throwable>();
        for (BackupResponse br : this.responses) {
            result.putAll(br.getFailedBackups());
        }
        return result;
    }

    @Override
    public Set<String> getCommunicationErrors() {
        HashSet<String> result = new HashSet<String>();
        for (BackupResponse br : this.responses) {
            result.addAll(br.getCommunicationErrors());
        }
        return result;
    }

    @Override
    public long getSendTimeMillis() {
        long min2 = Long.MAX_VALUE;
        for (BackupResponse br : this.responses) {
            min2 = Math.min(br.getSendTimeMillis(), min2);
        }
        return min2;
    }

    public String toString() {
        return "AggregateBackupResponse{responses=" + String.valueOf(this.responses) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregateBackupResponse)) {
            return false;
        }
        AggregateBackupResponse that = (AggregateBackupResponse)o;
        return this.responses != null ? this.responses.equals(that.responses) : that.responses == null;
    }

    public int hashCode() {
        return this.responses != null ? this.responses.hashCode() : 0;
    }

    @Override
    public boolean isEmpty() {
        for (BackupResponse br : this.responses) {
            if (br.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void notifyFinish(LongConsumer timeElapsedConsumer) {
        for (BackupResponse br : this.responses) {
            br.notifyFinish(timeElapsedConsumer);
        }
    }

    @Override
    public void notifyAsyncAck(XSiteAsyncAckListener listener) {
        for (BackupResponse br : this.responses) {
            br.notifyAsyncAck(listener);
        }
    }

    @Override
    public boolean isSync(String siteName) {
        for (BackupResponse br : this.responses) {
            if (!br.isSync(siteName)) continue;
            return true;
        }
        return false;
    }
}

