/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class CommitManager {
    private static final Log log = LogFactory.getLog(CommitManager.class);
    final Map<Integer, Map<Object, DiscardPolicy>> tracker = new ConcurrentHashMap<Integer, Map<Object, DiscardPolicy>>();
    @Inject
    InternalDataContainer dataContainer;
    @Inject
    PersistenceManager persistenceManager;
    @Inject
    TimeService timeService;
    private volatile boolean trackStateTransfer;
    private volatile boolean trackXSiteStateTransfer;

    public final void startTrack(Flag track) {
        this.setTrack(track, true);
    }

    public final void stopTrack(Flag track) {
        this.setTrack(track, false);
        if (!this.trackStateTransfer && !this.trackXSiteStateTransfer) {
            if (log.isTraceEnabled()) {
                log.tracef("Tracking is disabled. Clear tracker: %s", (Object)this.tracker);
            }
            this.tracker.clear();
        } else {
            this.tracker.values().removeIf(entries -> {
                entries.values().removeIf(policy -> policy.update(this.trackStateTransfer, this.trackXSiteStateTransfer));
                return entries.isEmpty();
            });
        }
    }

    public final void stopTrackFor(Flag flag, int segmentId) {
        if (flag == Flag.PUT_FOR_STATE_TRANSFER && this.trackStateTransfer) {
            this.tracker.computeIfPresent(segmentId, (k, entries) -> {
                entries.values().removeIf(DiscardPolicy::stopForST);
                return entries.isEmpty() ? null : entries;
            });
        }
    }

    public final CompletionStage<Void> commit(CacheEntry entry, Flag operation, int segment, boolean l1Only, InvocationContext ctx) {
        if (log.isTraceEnabled()) {
            log.tracef("Trying to commit. Key=%s. Operation Flag=%s, L1 write/invalidation=%s", (Object)Util.toStr(entry.getKey()), (Object)operation, (Object)l1Only);
        }
        if (l1Only || operation == null && !this.trackStateTransfer && !this.trackXSiteStateTransfer) {
            if (log.isTraceEnabled()) {
                log.tracef("Committing key=%s. It is a L1 invalidation or a normal put and no tracking is enabled!", (Object)Util.toStr(entry.getKey()));
            }
            return this.commitEntry(entry, segment, ctx);
        }
        if (this.isTrackDisabled(operation)) {
            if (log.isTraceEnabled()) {
                log.tracef("Not committing key=%s. It is a state transfer key but no track is enabled!", (Object)Util.toStr(entry.getKey()));
            }
            return CompletableFutures.completedNull();
        }
        ByRef<Object> byRef = new ByRef<Object>(null);
        Function<DiscardPolicy, DiscardPolicy> renewPolicy = discardPolicy -> {
            if (discardPolicy != null && discardPolicy.ignore(operation)) {
                if (log.isTraceEnabled()) {
                    log.tracef("Not committing key=%s. It was already overwritten! Discard policy=%s", (Object)Util.toStr(entry.getKey()), discardPolicy);
                }
                return discardPolicy;
            }
            byRef.set(this.commitEntry(entry, segment, ctx));
            DiscardPolicy newDiscardPolicy = this.calculateDiscardPolicy(operation);
            if (log.isTraceEnabled()) {
                log.tracef("Committed key=%s. Old discard policy=%s. New discard policy=%s", (Object)Util.toStr(entry.getKey()), discardPolicy, (Object)newDiscardPolicy);
            }
            return newDiscardPolicy;
        };
        this.tracker.compute(segment, (key, entries) -> {
            if (entries == null) {
                DiscardPolicy newDiscardPolicy = (DiscardPolicy)renewPolicy.apply(null);
                if (newDiscardPolicy != null) {
                    entries = new ConcurrentHashMap<Object, DiscardPolicy>();
                    entries.put(entry.getKey(), newDiscardPolicy);
                }
            } else {
                entries.compute(entry.getKey(), (e, discardPolicy) -> (DiscardPolicy)renewPolicy.apply((DiscardPolicy)discardPolicy));
            }
            return entries;
        });
        CompletionStage stage = byRef.get();
        if (stage != null) {
            return stage;
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> commitEntry(CacheEntry entry, int segment, InvocationContext ctx) {
        if (entry instanceof ReadCommittedEntry) {
            return ((ReadCommittedEntry)entry).commit(segment, this.dataContainer);
        }
        entry.commit(this.dataContainer);
        return CompletableFutures.completedNull();
    }

    public final boolean isTracking(Flag trackFlag) {
        switch (trackFlag) {
            case PUT_FOR_STATE_TRANSFER: {
                return this.trackStateTransfer;
            }
            case PUT_FOR_X_SITE_STATE_TRANSFER: {
                return this.trackXSiteStateTransfer;
            }
        }
        return false;
    }

    public final boolean isEmpty() {
        return this.tracker.isEmpty();
    }

    public String toString() {
        return "CommitManager{tracker=" + this.tracker.size() + " key(s), trackStateTransfer=" + this.trackStateTransfer + ", trackXSiteStateTransfer=" + this.trackXSiteStateTransfer + "}";
    }

    private void setTrack(Flag track, boolean value) {
        if (log.isTraceEnabled()) {
            log.tracef("Set track to %s = %s", (Object)track, (Object)value);
        }
        switch (track) {
            case PUT_FOR_STATE_TRANSFER: {
                this.trackStateTransfer = value;
                break;
            }
            case PUT_FOR_X_SITE_STATE_TRANSFER: {
                this.trackXSiteStateTransfer = value;
            }
        }
    }

    private boolean isTrackDisabled(Flag track) {
        return track == Flag.PUT_FOR_STATE_TRANSFER && !this.trackStateTransfer || track == Flag.PUT_FOR_X_SITE_STATE_TRANSFER && !this.trackXSiteStateTransfer;
    }

    private DiscardPolicy calculateDiscardPolicy(Flag operation) {
        boolean discardXSiteStateTransfer;
        boolean discardStateTransfer = this.trackStateTransfer && operation != Flag.PUT_FOR_STATE_TRANSFER;
        boolean bl = discardXSiteStateTransfer = this.trackXSiteStateTransfer && operation != Flag.PUT_FOR_X_SITE_STATE_TRANSFER;
        if (!discardStateTransfer && !discardXSiteStateTransfer) {
            return null;
        }
        return new DiscardPolicy(discardStateTransfer, discardXSiteStateTransfer);
    }

    private static class DiscardPolicy {
        private boolean discardST;
        private boolean discardXSiteST;

        private DiscardPolicy(boolean discardST, boolean discardXSiteST) {
            this.discardST = discardST;
            this.discardXSiteST = discardXSiteST;
        }

        public final synchronized boolean ignore(Flag operation) {
            return this.discardST && operation == Flag.PUT_FOR_STATE_TRANSFER || this.discardXSiteST && operation == Flag.PUT_FOR_X_SITE_STATE_TRANSFER;
        }

        public synchronized boolean update(boolean discardST, boolean discardXSiteST) {
            this.discardST = discardST;
            this.discardXSiteST = discardXSiteST;
            return !this.discardST && !this.discardXSiteST;
        }

        public boolean stopForST() {
            return this.update(false, this.discardXSiteST);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiscardPolicy that = (DiscardPolicy)o;
            return this.discardST == that.discardST && this.discardXSiteST == that.discardXSiteST;
        }

        public int hashCode() {
            int result = this.discardST ? 1 : 0;
            result = 31 * result + (this.discardXSiteST ? 1 : 0);
            return result;
        }

        public String toString() {
            return "DiscardPolicy{discardStateTransfer=" + this.discardST + ", discardXSiteStateTransfer=" + this.discardXSiteST + "}";
        }
    }
}

