/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.statetransfer.StateTransferCancelCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.PassthroughSingleResponseCollector;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InboundTransferTask {
    private static final Log log = LogFactory.getLog(InboundTransferTask.class);
    @GuardedBy(value="segments")
    private final IntSet segments;
    @GuardedBy(value="segments")
    private final IntSet unfinishedSegments;
    private final Address source;
    private volatile boolean isCancelled = false;
    private final CompletableFuture<Void> completionFuture = new CompletableFuture();
    private final int topologyId;
    private final RpcManager rpcManager;
    private final CommandsFactory commandsFactory;
    private final long timeout;
    private final String cacheName;
    private final boolean applyState;
    private final RpcOptions rpcOptions;

    public InboundTransferTask(IntSet segments, Address source, int topologyId, RpcManager rpcManager, CommandsFactory commandsFactory, long timeout, String cacheName, boolean applyState) {
        if (segments == null || segments.isEmpty()) {
            throw new IllegalArgumentException("segments must not be null or empty");
        }
        if (source == null) {
            throw new IllegalArgumentException("Source address cannot be null");
        }
        this.segments = IntSets.mutableCopyFrom(segments);
        this.unfinishedSegments = IntSets.mutableCopyFrom(segments);
        this.source = source;
        this.topologyId = topologyId;
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.timeout = timeout;
        this.cacheName = cacheName;
        this.applyState = applyState;
        this.rpcOptions = new RpcOptions(DeliverOrder.NONE, timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntSet getSegments() {
        IntSet intSet = this.segments;
        synchronized (intSet) {
            return IntSets.mutableCopyFrom(this.segments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntSet getUnfinishedSegments() {
        IntSet intSet = this.segments;
        synchronized (intSet) {
            return IntSets.mutableCopyFrom(this.unfinishedSegments);
        }
    }

    public Address getSource() {
        return this.source;
    }

    public CompletionStage<Void> requestSegments() {
        return this.startTransfer(this.applyState ? segments -> this.commandsFactory.buildStateTransferStartCommand(this.topologyId, (IntSet)segments) : segments -> this.commandsFactory.buildConflictResolutionStartCommand(this.topologyId, (IntSet)segments));
    }

    public CompletionStage<Void> requestKeys() {
        return this.startTransfer(segments -> this.commandsFactory.buildScatteredStateGetKeysCommand(this.topologyId, (IntSet)segments));
    }

    private CompletionStage<Void> startTransfer(Function<IntSet, CacheRpcCommand> transferCommand) {
        if (this.isCancelled) {
            return this.completionFuture;
        }
        IntSet segmentsCopy = this.getSegments();
        if (segmentsCopy.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.tracef("Segments list is empty, skipping source %s", (Object)this.source);
            }
            this.completionFuture.complete(null);
            return this.completionFuture;
        }
        CacheRpcCommand cmd = transferCommand.apply(segmentsCopy);
        if (log.isTraceEnabled()) {
            log.tracef("Requesting state (%s) from node %s for segments %s", (Object)cmd, (Object)this.source, (Object)segmentsCopy);
        }
        CompletionStage<Response> remoteStage = this.rpcManager.invokeCommand(this.source, (ReplicableCommand)cmd, PassthroughSingleResponseCollector.INSTANCE, this.rpcOptions);
        return CompletionStages.handleAndCompose(remoteStage, (response, throwable) -> {
            if (throwable != null) {
                if (!this.isCancelled) {
                    log.failedToRequestSegments(this.cacheName, this.source, segmentsCopy, (Throwable)throwable);
                    this.completionFuture.completeExceptionally((Throwable)throwable);
                }
            } else if (response instanceof SuccessfulResponse) {
                if (log.isTraceEnabled()) {
                    log.tracef("Successfully requested state (%s) from node %s for segments %s", (Object)cmd, (Object)this.source, (Object)segmentsCopy);
                }
            } else if (response instanceof CacheNotFoundResponse) {
                if (log.isTraceEnabled()) {
                    log.tracef("State source %s was suspected, another source will be selected", (Object)this.source);
                }
                this.completionFuture.completeExceptionally(new SuspectException());
            } else {
                CacheException e = new CacheException(String.valueOf(response));
                log.failedToRequestSegments(this.cacheName, this.source, segmentsCopy, e);
                this.completionFuture.completeExceptionally(e);
            }
            return this.completionFuture;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSegments(IntSet cancelledSegments) {
        if (this.isCancelled) {
            throw new IllegalArgumentException("The task is already cancelled.");
        }
        if (log.isTraceEnabled()) {
            log.tracef("Partially cancelling inbound state transfer from node %s, segments %s", (Object)this.source, (Object)cancelledSegments);
        }
        IntSet intSet = this.segments;
        synchronized (intSet) {
            if (!this.segments.containsAll(cancelledSegments)) {
                throw new IllegalArgumentException("Some of the specified segments cannot be cancelled because they were not previously requested");
            }
            this.unfinishedSegments.removeAll(cancelledSegments);
            if (this.unfinishedSegments.isEmpty()) {
                this.isCancelled = true;
            }
        }
        this.sendCancelCommand(cancelledSegments);
        if (this.isCancelled) {
            this.notifyCompletion(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.isCancelled) {
            this.isCancelled = true;
            IntSet segmentsCopy = this.getUnfinishedSegments();
            IntSet intSet = this.segments;
            synchronized (intSet) {
                this.unfinishedSegments.clear();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Cancelling inbound state transfer from %s with unfinished segments %s", (Object)this.source, (Object)segmentsCopy);
            }
            this.sendCancelCommand(segmentsCopy);
            this.notifyCompletion(false);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private void sendCancelCommand(IntSet cancelledSegments) {
        StateTransferCancelCommand cmd = this.commandsFactory.buildStateTransferCancelCommand(this.topologyId, cancelledSegments);
        try {
            this.rpcManager.sendTo(this.source, cmd, DeliverOrder.NONE);
        }
        catch (Exception e) {
            log.debugf("Caught an exception while cancelling state transfer from node %s for segments %s", (Object)this.source, (Object)cancelledSegments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStateReceived(int segmentId, boolean isLastChunk) {
        if (!this.isCancelled && isLastChunk) {
            boolean isCompleted = false;
            IntSet intSet = this.segments;
            synchronized (intSet) {
                if (this.segments.contains(segmentId)) {
                    this.unfinishedSegments.remove(segmentId);
                    if (this.unfinishedSegments.isEmpty()) {
                        log.debugf("Finished receiving state for segments %s", (Object)this.segments);
                        isCompleted = true;
                    }
                }
            }
            if (isCompleted) {
                this.notifyCompletion(true);
            }
        }
    }

    private void notifyCompletion(boolean success) {
        if (success) {
            this.completionFuture.complete(null);
        } else {
            this.completionFuture.completeExceptionally(new CancellationException("Inbound transfer was cancelled"));
        }
    }

    public boolean isCompletedSuccessfully() {
        return this.completionFuture.isDone() && !this.completionFuture.isCompletedExceptionally();
    }

    public void terminate() {
        this.notifyCompletion(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        IntSet intSet = this.segments;
        synchronized (intSet) {
            return "InboundTransferTask{segments=" + String.valueOf(this.segments) + ", unfinishedSegments=" + String.valueOf(this.unfinishedSegments) + ", source=" + String.valueOf(this.source) + ", isCancelled=" + this.isCancelled + ", completionFuture=" + String.valueOf(this.completionFuture) + ", topologyId=" + this.topologyId + ", timeout=" + this.timeout + ", cacheName=" + this.cacheName + "}";
        }
    }
}

