/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.time.TimeService;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.util.logging.Log;

@MBean
@Scope(value=Scopes.NONE)
abstract class AbstractStats
implements JmxStatisticsExposer {
    public static final long DEFAULT_STALE_STATS_THRESHOLD = 3000L;
    protected volatile long staleStatsThreshold = 3000L;
    protected volatile long statsUpdateTimestamp = 0L;
    @Inject
    TimeService timeService;
    volatile boolean statisticsEnabled = false;
    protected final Log log;
    final AtomicLong resetNanoseconds = new AtomicLong(0L);
    final HashMap<String, Number> statsMap = new HashMap();

    AbstractStats(Log log) {
        this.log = log;
    }

    abstract void updateStats() throws Exception;

    @Start
    void start() {
        this.setStatisticsEnabled(this.statisticsEnabled);
    }

    public void reset() {
        this.statsMap.clear();
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        if (this.getStatisticsEnabled()) {
            this.reset();
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
        if (enabled) {
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStaleStatsThreshold(long staleStatsThreshold) {
        this.staleStatsThreshold = staleStatsThreshold;
    }

    long addLongAttributes(Collection<Map<String, Number>> responseList, String attribute) {
        long total = 0L;
        for (Map<String, Number> m4 : responseList) {
            Number value = m4.get(attribute);
            long longValue = value.longValue();
            if (longValue >= 0L) {
                total += longValue;
                continue;
            }
            total = -1L;
        }
        return total;
    }

    private int addIntAttributes(Collection<Map<String, Number>> responseList, String attribute) {
        int total = 0;
        for (Map<String, Number> m4 : responseList) {
            Number value = m4.get(attribute);
            int intValue = value.intValue();
            if (intValue >= 0) {
                total += intValue;
                continue;
            }
            total = -1;
        }
        return total;
    }

    private int maxIntAttributes(Collection<Map<String, Number>> responseList, String attribute) {
        int max = -1;
        for (Map<String, Number> m4 : responseList) {
            Number value = m4.get(attribute);
            int intValue = value.intValue();
            max = Math.max(max, intValue);
        }
        return max;
    }

    void putLongAttributesAverage(Collection<Map<String, Number>> responseList, String attribute) {
        long numValues = 0L;
        long total = 0L;
        for (Map<String, Number> m4 : responseList) {
            Number value = m4.get(attribute);
            long longValue = value.longValue();
            if (longValue < 0L) continue;
            total += longValue;
            ++numValues;
        }
        if (numValues > 0L) {
            long average = total / numValues;
            this.statsMap.put(attribute, average);
        }
    }

    void putLongAttributes(Collection<Map<String, Number>> responseList, String attribute) {
        this.statsMap.put(attribute, this.addLongAttributes(responseList, attribute));
    }

    void putIntAttributes(Collection<Map<String, Number>> responseList, String attribute) {
        this.statsMap.put(attribute, this.addIntAttributes(responseList, attribute));
    }

    void putIntAttributesMax(Collection<Map<String, Number>> responseList, String attribute) {
        this.statsMap.put(attribute, this.maxIntAttributes(responseList, attribute));
    }

    long getStatAsLong(String attribute) {
        return this.getStat(attribute).longValue();
    }

    int getStatAsInt(String attribute) {
        return this.getStat(attribute).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void fetchStatsIfNeeded() {
        long duration = this.timeService.timeDuration(this.statsUpdateTimestamp, this.timeService.time(), TimeUnit.MILLISECONDS);
        if (duration > this.staleStatsThreshold) {
            try {
                this.updateStats();
            }
            catch (Exception e) {
                this.log.error("Could not execute cluster wide cache stats operation ", e);
            }
            finally {
                this.statsUpdateTimestamp = this.timeService.time();
            }
        }
    }

    protected Number getStat(String attribute) {
        if (this.getStatisticsEnabled()) {
            this.fetchStatsIfNeeded();
            return this.statsMap.getOrDefault(attribute, 0);
        }
        return -1;
    }
}

