/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.Ids;

public class StreamMarshalling {
    private StreamMarshalling() {
    }

    public static Predicate<Object> equalityPredicate(Object object) {
        return new EqualityPredicate(object);
    }

    public static Predicate<Object> nonNullPredicate() {
        return NonNullPredicate.getInstance();
    }

    public static Predicate<Object> alwaysTruePredicate() {
        return AlwaysTruePredicate.getInstance();
    }

    public static <K, V> Function<Map.Entry<K, V>, K> entryToKeyFunction() {
        return EntryToKeyFunction.getInstance();
    }

    public static <K, V> Function<Map.Entry<K, V>, V> entryToValueFunction() {
        return EntryToValueFunction.getInstance();
    }

    public static <T> Function<T, T> identity() {
        return IdentityFunction.getInstance();
    }

    public static <K, V> Function<K, CacheEntry<K, V>> keyToEntryFunction() {
        return new KeyToEntryFunction();
    }

    private static final class EqualityPredicate
    implements Predicate<Object> {
        private final Object object;

        private EqualityPredicate(Object object) {
            Objects.nonNull(object);
            this.object = object;
        }

        @Override
        public boolean test(Object t2) {
            return this.object.equals(t2);
        }
    }

    private static final class NonNullPredicate
    implements Predicate<Object> {
        private static final NonNullPredicate INSTANCE = new NonNullPredicate();

        private NonNullPredicate() {
        }

        public static NonNullPredicate getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean test(Object t2) {
            return t2 != null;
        }
    }

    private static final class AlwaysTruePredicate
    implements Predicate<Object> {
        private static final AlwaysTruePredicate INSTANCE = new AlwaysTruePredicate();

        private AlwaysTruePredicate() {
        }

        public static AlwaysTruePredicate getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean test(Object t2) {
            return true;
        }
    }

    private static final class EntryToKeyFunction<K, V>
    implements Function<Map.Entry<K, V>, K> {
        private static final EntryToKeyFunction<?, ?> FUNCTION = new EntryToKeyFunction();

        private EntryToKeyFunction() {
        }

        public static <K, V> EntryToKeyFunction<K, V> getInstance() {
            return FUNCTION;
        }

        @Override
        public K apply(Map.Entry<K, V> kvEntry) {
            return kvEntry.getKey();
        }
    }

    private static final class EntryToValueFunction<K, V>
    implements Function<Map.Entry<K, V>, V> {
        private static final EntryToValueFunction<?, ?> FUNCTION = new EntryToValueFunction();

        private EntryToValueFunction() {
        }

        public static <K, V> EntryToValueFunction<K, V> getInstance() {
            return FUNCTION;
        }

        @Override
        public V apply(Map.Entry<K, V> kvEntry) {
            return kvEntry.getValue();
        }
    }

    private static final class IdentityFunction<T>
    implements Function<T, T> {
        private static final IdentityFunction<?> FUNCTION = new IdentityFunction();

        private IdentityFunction() {
        }

        public static <T> IdentityFunction<T> getInstance() {
            return FUNCTION;
        }

        @Override
        public T apply(T t2) {
            return t2;
        }
    }

    @Scope(value=Scopes.NONE)
    static final class KeyToEntryFunction<K, V>
    implements Function<K, CacheEntry<K, V>> {
        @Inject
        AdvancedCache<K, V> advancedCache;

        KeyToEntryFunction() {
        }

        @Override
        public CacheEntry<K, V> apply(K k) {
            return this.advancedCache.getCacheEntry(k);
        }
    }

    public static final class StreamMarshallingExternalizer
    implements AdvancedExternalizer<Object> {
        private final Map<Class<? extends Object>, ExternalizerId> objects = new HashMap<Class<? extends Object>, ExternalizerId>();

        public StreamMarshallingExternalizer() {
            for (ExternalizerId id : ExternalizerId.values()) {
                this.objects.put(id.marshalledClass, id);
            }
        }

        @Override
        public Set<Class<?>> getTypeClasses() {
            return Util.asSet(EqualityPredicate.class, EntryToKeyFunction.class, EntryToValueFunction.class, NonNullPredicate.class, AlwaysTruePredicate.class, KeyToEntryFunction.class, IdentityFunction.class);
        }

        @Override
        public Integer getId() {
            return Ids.STREAM_MARSHALLING;
        }

        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            ExternalizerId id = this.objects.get(object.getClass());
            if (id == null) {
                throw new IllegalArgumentException("Unsupported class " + String.valueOf(object.getClass()) + " was provided!");
            }
            output.writeByte(id.ordinal());
            switch (id.ordinal()) {
                case 0: {
                    output.writeObject(((EqualityPredicate)object).object);
                }
            }
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int number = input.readUnsignedByte();
            ExternalizerId[] ids = ExternalizerId.values();
            if (number < 0 || number >= ids.length) {
                throw new IllegalArgumentException("Found invalid number " + number);
            }
            ExternalizerId id = ids[number];
            switch (id.ordinal()) {
                case 0: {
                    return new EqualityPredicate(input.readObject());
                }
                case 1: {
                    return EntryToKeyFunction.getInstance();
                }
                case 2: {
                    return EntryToValueFunction.getInstance();
                }
                case 3: {
                    return NonNullPredicate.getInstance();
                }
                case 4: {
                    return AlwaysTruePredicate.getInstance();
                }
                case 5: {
                    return new KeyToEntryFunction();
                }
                case 6: {
                    return IdentityFunction.getInstance();
                }
            }
            throw new IllegalArgumentException("ExternalizerId not supported: " + String.valueOf((Object)id));
        }

        static enum ExternalizerId {
            EQUALITY_PREDICATE(EqualityPredicate.class),
            ENTRY_KEY_FUNCTION(EntryToKeyFunction.class),
            ENTRY_VALUE_FUNCTION(EntryToValueFunction.class),
            NON_NULL_PREDICATE(NonNullPredicate.class),
            ALWAYS_TRUE_PREDICATE(AlwaysTruePredicate.class),
            KEY_ENTRY_FUNCTION(KeyToEntryFunction.class),
            IDENTITY_FUNCTION(IdentityFunction.class);

            private final Class<? extends Object> marshalledClass;

            private ExternalizerId(Class<? extends Object> marshalledClass) {
                this.marshalledClass = marshalledClass;
            }
        }
    }
}

