/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.intops.primitive.i;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.util.concurrent.BlockingManager;

public class PeekIntOperation
implements IntermediateOperation<Integer, IntStream, Integer, IntStream> {
    private final IntConsumer consumer;
    private BlockingManager blockingManager;

    public PeekIntOperation(IntConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public IntStream perform(IntStream stream) {
        return stream.peek(this.consumer);
    }

    public IntConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void handleInjection(ComponentRegistry registry) {
        this.blockingManager = registry.getBlockingManager().running();
        if (this.consumer instanceof CacheAware) {
            ((CacheAware)((Object)this.consumer)).injectCache(registry.getCache().running());
        } else {
            registry.wireDependencies(this.consumer);
        }
    }

    @Override
    public Flowable<Integer> mapFlowable(Flowable<Integer> input) {
        return input.concatMapSingle(t2 -> Single.fromCompletionStage(this.blockingManager.supplyBlocking(() -> {
            this.consumer.accept((int)t2);
            return t2;
        }, "publisher-peek")));
    }
}

