/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteTransaction
extends AbstractCacheTransaction {
    private static final Log log = LogFactory.getLog(RemoteTransaction.class);
    private static final CompletableFuture<Void> INITIAL_FUTURE = CompletableFutures.completedNull();
    private volatile int lookedUpEntriesTopology = Integer.MAX_VALUE;
    private final AtomicReference<CompletableFuture<Void>> synchronization = new AtomicReference<CompletableFuture<Void>>(INITIAL_FUTURE);

    public RemoteTransaction(List<WriteCommand> modifications, GlobalTransaction tx, int topologyId, long txCreationTime) {
        super(tx, topologyId, txCreationTime);
        this.lookedUpEntries = new HashMap(modifications.size());
        this.setModifications(modifications);
    }

    public RemoteTransaction(GlobalTransaction tx, int topologyId, long txCreationTime) {
        super(tx, topologyId, txCreationTime);
        this.lookedUpEntries = new HashMap(4);
    }

    @Override
    public void setStateTransferFlag(Flag stateTransferFlag) {
        if (this.getStateTransferFlag() == null && stateTransferFlag == Flag.PUT_FOR_X_SITE_STATE_TRANSFER) {
            this.internalSetStateTransferFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
        }
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.checkIfRolledBack();
        if (log.isTraceEnabled()) {
            log.tracef("Adding key %s to tx %s", (Object)Util.toStr(key), (Object)this.getGlobalTransaction());
        }
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> entries) {
        this.checkIfRolledBack();
        if (log.isTraceEnabled()) {
            log.tracef("Adding keys %s to tx %s", (Object)entries.keySet(), (Object)this.getGlobalTransaction());
        }
        this.lookedUpEntries.putAll(entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTransaction)) {
            return false;
        }
        RemoteTransaction that = (RemoteTransaction)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public String toString() {
        return "RemoteTransaction{modifications=" + String.valueOf(this.modifications) + ", lookedUpEntries=" + String.valueOf(this.lookedUpEntries) + ", lockedKeys=" + Util.toStr(this.getLockedKeys()) + ", backupKeyLocks=" + Util.toStr(this.getBackupLockedKeys()) + ", lookedUpEntriesTopology=" + this.lookedUpEntriesTopology + ", isMarkedForRollback=" + this.isMarkedForRollback() + ", tx=" + String.valueOf(this.tx) + "}";
    }

    public void setLookedUpEntriesTopology(int lookedUpEntriesTopology) {
        this.lookedUpEntriesTopology = lookedUpEntriesTopology;
    }

    public int lookedUpEntriesTopology() {
        return this.lookedUpEntriesTopology;
    }

    public final CompletableFuture<Void> enterSynchronizationAsync(CompletableFuture<Void> releaseFuture) {
        CompletableFuture<Void> currentFuture;
        while (!this.synchronization.compareAndSet(currentFuture = this.synchronization.get(), releaseFuture)) {
        }
        return currentFuture;
    }
}

