/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.lookup;

import jakarta.transaction.TransactionManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.commons.tx.lookup.LookupNames;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.infinispan.transaction.lookup.WildflyTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class GenericTransactionManagerLookup
implements TransactionManagerLookup {
    private static final Log log = LogFactory.getLog(GenericTransactionManagerLookup.class);
    public static final GenericTransactionManagerLookup INSTANCE = new GenericTransactionManagerLookup();
    private boolean lookupDone = false;
    private boolean lookupFailed = false;
    private boolean noJBossTM = false;
    private TransactionManager tm = null;
    @Inject
    GlobalConfiguration globalCfg;

    @Override
    public synchronized TransactionManager getTransactionManager() {
        if (!this.lookupDone) {
            this.doLookups(this.globalCfg.classLoader());
        }
        if (this.tm != null) {
            return this.tm;
        }
        if (this.lookupFailed) {
            if (!this.noJBossTM) {
                this.tryEmbeddedJBossTM();
            }
            if (this.noJBossTM) {
                this.useDummyTM();
            }
        }
        return this.tm;
    }

    private void useDummyTM() {
        this.tm = EmbeddedTransactionManager.getInstance();
        Log.CONTAINER.fallingBackToEmbeddedTm();
    }

    private void tryEmbeddedJBossTM() {
        try {
            WildflyTransactionManagerLookup lookup = new WildflyTransactionManagerLookup();
            lookup.init(this.globalCfg);
            this.tm = lookup.getTransactionManager();
            return;
        }
        catch (Exception lookup) {
            try {
                JBossStandaloneJTAManagerLookup jBossStandaloneJTAManagerLookup = new JBossStandaloneJTAManagerLookup();
                jBossStandaloneJTAManagerLookup.init(this.globalCfg);
                this.tm = jBossStandaloneJTAManagerLookup.getTransactionManager();
            }
            catch (Exception e) {
                this.noJBossTM = true;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLookups(ClassLoader cl) {
        InitialContext ctx;
        if (this.lookupFailed) {
            return;
        }
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            Log.CONTAINER.failedToCreateInitialCtx(e);
            this.lookupFailed = true;
            return;
        }
        try {
            for (LookupNames.JndiTransactionManager knownJNDIManager : LookupNames.JndiTransactionManager.values()) {
                Object jndiObject;
                try {
                    log.debugf("Trying to lookup TransactionManager for %s", (Object)knownJNDIManager.getPrettyName());
                    jndiObject = ctx.lookup(knownJNDIManager.getJndiLookup());
                }
                catch (NamingException e) {
                    log.debugf("Failed to perform a lookup for [%s (%s)]", (Object)knownJNDIManager.getJndiLookup(), (Object)knownJNDIManager.getPrettyName());
                    continue;
                }
                if (!(jndiObject instanceof TransactionManager)) continue;
                this.tm = (TransactionManager)jndiObject;
                log.debugf("Found TransactionManager for %s", (Object)knownJNDIManager.getPrettyName());
                return;
            }
        }
        finally {
            Util.close(ctx);
        }
        boolean found = true;
        for (LookupNames.TransactionManagerFactory transactionManagerFactory : LookupNames.TransactionManagerFactory.values()) {
            log.debugf("Trying %s: %s", (Object)transactionManagerFactory.getPrettyName(), (Object)transactionManagerFactory.getFactoryClazz());
            TransactionManager transactionManager = transactionManagerFactory.tryLookup(cl);
            if (transactionManager == null) continue;
            log.debugf("Found %s: %s", (Object)transactionManagerFactory.getPrettyName(), (Object)transactionManagerFactory.getFactoryClazz());
            this.tm = transactionManager;
            found = false;
        }
        this.lookupDone = true;
        this.lookupFailed = found;
    }
}

