/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.commons.tx.AsyncXaResource;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.transaction.impl.AbstractEnlistmentAdapter;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionXaAdapter
extends AbstractEnlistmentAdapter
implements XAResource,
AsyncXaResource {
    private static final Log log = LogFactory.getLog(TransactionXaAdapter.class);
    private int txTimeout;
    private final XaTransactionTable txTable;
    private final LocalXaTransaction localTransaction;
    private volatile RecoveryManager.RecoveryIterator recoveryIterator;

    public TransactionXaAdapter(LocalXaTransaction localTransaction, XaTransactionTable txTable) {
        super(localTransaction);
        this.txTable = txTable;
        this.localTransaction = localTransaction;
    }

    public TransactionXaAdapter(XaTransactionTable txTable) {
        this.txTable = txTable;
        this.localTransaction = null;
    }

    @Override
    public int prepare(Xid externalXid) throws XAException {
        return TransactionXaAdapter.runRethrowingXAException(this.txTable.prepare(XidImpl.copy(externalXid)));
    }

    @Override
    public void commit(Xid externalXid, boolean isOnePhase) throws XAException {
        TransactionXaAdapter.runRethrowingXAException(this.txTable.commit(XidImpl.copy(externalXid), isOnePhase));
    }

    @Override
    public void rollback(Xid externalXid) throws XAException {
        TransactionXaAdapter.runRethrowingXAException(this.txTable.rollback(XidImpl.copy(externalXid)));
    }

    @Override
    public void start(Xid externalXid, int i) throws XAException {
        assert (this.localTransaction != null);
        this.txTable.start(XidImpl.copy(externalXid), this.localTransaction);
    }

    @Override
    public void end(Xid externalXid, int i) {
        this.txTable.end(this.localTransaction);
    }

    @Override
    public void forget(Xid externalXid) throws XAException {
        TransactionXaAdapter.runRethrowingXAException(this.txTable.forget(XidImpl.copy(externalXid)));
    }

    @Override
    public int getTransactionTimeout() {
        if (log.isTraceEnabled()) {
            log.trace("start called");
        }
        return this.txTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) {
        return this.isIsSameRM(xaResource);
    }

    private boolean isIsSameRM(XAResource xaResource) {
        if (!(xaResource instanceof TransactionXaAdapter)) {
            return false;
        }
        TransactionXaAdapter other = (TransactionXaAdapter)xaResource;
        return this.txTable == other.txTable;
    }

    @Override
    public Xid[] recover(int flag) {
        if (!this.txTable.isRecoveryEnabled()) {
            log.recoveryIgnored();
            return RecoveryManager.RecoveryIterator.NOTHING;
        }
        if (log.isTraceEnabled()) {
            log.trace("recover called: " + flag);
        }
        if (TransactionXaAdapter.isFlag(flag, 0x1000000)) {
            this.recoveryIterator = this.txTable.recoveryManager.getPreparedTransactionsFromCluster();
            if (log.isTraceEnabled()) {
                log.tracef("Fetched a new recovery iterator: %s", (Object)this.recoveryIterator);
            }
        }
        if (TransactionXaAdapter.isFlag(flag, 0x800000)) {
            if (log.isTraceEnabled()) {
                log.trace("Flushing the iterator");
            }
            return this.recoveryIterator.all();
        }
        if (!TransactionXaAdapter.isFlag(flag, 0x1000000) && !TransactionXaAdapter.isFlag(flag, 0)) {
            throw new IllegalArgumentException("TMNOFLAGS this flag must be used when no other flags are specified. Received " + flag);
        }
        return this.recoveryIterator.hasNext() ? (Xid[])this.recoveryIterator.next() : RecoveryManager.RecoveryIterator.NOTHING;
    }

    @Override
    public boolean setTransactionTimeout(int i) {
        this.txTimeout = i;
        return true;
    }

    public String toString() {
        return "TransactionXaAdapter{localTransaction=" + String.valueOf(this.localTransaction) + "}";
    }

    public LocalXaTransaction getLocalTransaction() {
        return this.localTransaction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionXaAdapter that = (TransactionXaAdapter)o;
        return Objects.equals(this.localTransaction, that.localTransaction) && this.txTable == that.txTable;
    }

    private static boolean isFlag(int value, int flag) {
        return (value & flag) != 0;
    }

    private static <T> T runRethrowingXAException(CompletionStage<T> completionStage) throws XAException {
        try {
            return CompletionStages.join(completionStage);
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof XAException) {
                throw (XAException)cause;
            }
            throw e;
        }
    }

    @Override
    public CompletionStage<Void> asyncEnd(XidImpl xid, int flags) {
        this.txTable.end(this.localTransaction);
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Integer> asyncPrepare(XidImpl xid) {
        return this.txTable.prepare(xid);
    }

    @Override
    public CompletionStage<Void> asyncCommit(XidImpl xid, boolean onePhase) {
        return this.txTable.commit(xid, onePhase);
    }

    @Override
    public CompletionStage<Void> asyncRollback(XidImpl xid) {
        return this.txTable.rollback(xid);
    }
}

