/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.transaction.xa.recovery.InDoubtTxInfo;
import org.infinispan.transaction.xa.recovery.PreparedTxIterator;
import org.infinispan.transaction.xa.recovery.RecoveryAwareLocalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryInfoKey;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class RecoveryManagerImpl
implements RecoveryManager {
    private static final Log log = LogFactory.getLog(RecoveryManagerImpl.class);
    private volatile RpcManager rpcManager;
    private volatile CommandsFactory commandFactory;
    private final ConcurrentMap<RecoveryInfoKey, RecoveryAwareRemoteTransaction> inDoubtTransactions;
    private final String cacheName;
    private ComponentRef<TransactionTable> txTable;
    private TransactionCoordinator txCoordinator;
    private TransactionFactory txFactory;
    private volatile boolean broadcastForPreparedTx = true;

    public RecoveryManagerImpl(ConcurrentMap<RecoveryInfoKey, RecoveryAwareRemoteTransaction> recoveryHolder, String cacheName) {
        this.inDoubtTransactions = recoveryHolder;
        this.cacheName = cacheName;
    }

    @Inject
    public void init(RpcManager rpcManager, CommandsFactory commandsFactory, ComponentRef<TransactionTable> txTable, TransactionCoordinator txCoordinator, TransactionFactory txFactory) {
        this.rpcManager = rpcManager;
        this.commandFactory = commandsFactory;
        this.txTable = txTable;
        this.txCoordinator = txCoordinator;
        this.txFactory = txFactory;
    }

    @Override
    public RecoveryManager.RecoveryIterator getPreparedTransactionsFromCluster() {
        PreparedTxIterator iterator = new PreparedTxIterator();
        iterator.add(this.recoveryAwareTxTable().getLocalPreparedXids());
        iterator.add(this.getInDoubtTransactions());
        if (this.notOnlyMeInTheCluster() && this.broadcastForPreparedTx) {
            boolean success = true;
            Map<Address, Response> responses = this.getAllPreparedTxFromCluster();
            for (Map.Entry<Address, Response> rEntry : responses.entrySet()) {
                Response thisResponse = rEntry.getValue();
                if (this.isSuccessful(thisResponse)) {
                    List responseValue = (List)((SuccessfulResponse)thisResponse).getResponseValue();
                    if (log.isTraceEnabled()) {
                        log.tracef("Received Xid lists %s from node %s", (Object)responseValue, (Object)rEntry.getKey());
                    }
                    iterator.add(responseValue);
                    continue;
                }
                log.missingListPreparedTransactions(rEntry.getKey(), rEntry.getValue());
                success = false;
            }
            boolean bl = this.broadcastForPreparedTx = !success;
            if (!this.broadcastForPreparedTx) {
                log.debug("Finished broadcasting for remote prepared transactions. Returning only local values from now on.");
            }
        }
        return iterator;
    }

    @Override
    public CompletionStage<Void> removeRecoveryInformation(Collection<Address> lockOwners, XidImpl xid, GlobalTransaction gtx, boolean fromCluster) {
        if (log.isTraceEnabled()) {
            log.tracef("Forgetting tx information for %s", (Object)gtx);
        }
        if (this.rpcManager != null && !fromCluster) {
            TxCompletionNotificationCommand ftc = this.commandFactory.buildTxCompletionNotificationCommand(xid, gtx);
            CompletionStage<Void> stage = this.sendTxCompletionNotification(lockOwners, ftc);
            this.removeRecoveryInformation(xid);
            return stage;
        }
        this.removeRecoveryInformation(xid);
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> removeRecoveryInformationFromCluster(Collection<Address> where, long internalId) {
        if (this.rpcManager != null) {
            TxCompletionNotificationCommand ftc = this.commandFactory.buildTxCompletionNotificationCommand(internalId);
            CompletionStage<Void> stage = this.sendTxCompletionNotification(where, ftc);
            this.removeRecoveryInformation(internalId);
            return stage;
        }
        this.removeRecoveryInformation(internalId);
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> sendTxCompletionNotification(Collection<Address> where, TxCompletionNotificationCommand ftc) {
        ftc.setTopologyId(this.rpcManager.getTopologyId());
        if (where == null) {
            return this.rpcManager.invokeCommandOnAll(ftc, VoidResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        }
        return this.rpcManager.invokeCommand(where, (ReplicableCommand)ftc, VoidResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
    }

    @Override
    public RecoveryAwareTransaction removeRecoveryInformation(XidImpl xid) {
        RecoveryAwareTransaction remove = (RecoveryAwareTransaction)this.inDoubtTransactions.remove(new RecoveryInfoKey(xid, this.cacheName));
        log.tracef("removed in doubt xid: %s", (Object)xid);
        if (remove == null) {
            return (RecoveryAwareTransaction)((Object)this.recoveryAwareTxTable().removeRemoteTransaction(xid));
        }
        return remove;
    }

    @Override
    public RecoveryAwareTransaction removeRecoveryInformation(Long internalId) {
        XidImpl remoteTransactionXid = this.recoveryAwareTxTable().getRemoteTransactionXid(internalId);
        if (remoteTransactionXid != null) {
            return this.removeRecoveryInformation(remoteTransactionXid);
        }
        for (RecoveryAwareRemoteTransaction raRemoteTx : this.inDoubtTransactions.values()) {
            GlobalTransaction globalTransaction = raRemoteTx.getGlobalTransaction();
            if (!internalId.equals(globalTransaction.getInternalId())) continue;
            XidImpl xid = globalTransaction.getXid();
            log.tracef("Found transaction xid %s that maps internal id %s", (Object)xid, (Object)internalId);
            this.removeRecoveryInformation(xid);
            return raRemoteTx;
        }
        log.tracef("Could not find tx to map to internal id %s", (Object)internalId);
        return null;
    }

    @Override
    public List<XidImpl> getInDoubtTransactions() {
        List<XidImpl> result = this.inDoubtTransactions.keySet().stream().filter(recoveryInfoKey -> recoveryInfoKey.cacheName.equals(this.cacheName)).map(recoveryInfoKey -> recoveryInfoKey.xid).collect(Collectors.toList());
        log.tracef("Returning %s ", (Object)result);
        return result;
    }

    @Override
    public Set<InDoubtTxInfo> getInDoubtTransactionInfo() {
        Set<RecoveryAwareLocalTransaction> localTxs = this.recoveryAwareTxTable().getLocalTxThatFailedToComplete();
        log.tracef("Local transactions that failed to complete is %s", (Object)localTxs);
        HashSet<InDoubtTxInfo> result = new HashSet<InDoubtTxInfo>();
        for (RecoveryAwareLocalTransaction r : localTxs) {
            long internalId = r.getGlobalTransaction().getInternalId();
            result.add(new InDoubtTxInfo(r.getXid(), internalId));
        }
        for (XidImpl xid : this.getInDoubtTransactions()) {
            RecoveryAwareRemoteTransaction pTx = this.getPreparedTransaction(xid);
            if (pTx == null) continue;
            GlobalTransaction gtx = pTx.getGlobalTransaction();
            InDoubtTxInfo infoInDoubt = new InDoubtTxInfo(xid, gtx.getInternalId(), pTx.getStatus());
            result.add(infoInDoubt);
        }
        log.tracef("The set of in-doubt txs from this node is %s", (Object)result);
        return result;
    }

    @Override
    public Set<InDoubtTxInfo> getInDoubtTransactionInfoFromCluster() {
        HashMap<XidImpl, InDoubtTxInfo> result = new HashMap<XidImpl, InDoubtTxInfo>();
        if (this.rpcManager != null) {
            GetInDoubtTxInfoCommand inDoubtTxInfoCommand = this.commandFactory.buildGetInDoubtTxInfoCommand();
            CompletionStage<Map<Address, Response>> completionStage = this.rpcManager.invokeCommandOnAll(inDoubtTxInfoCommand, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
            Map<Address, Response> addressResponseMap = this.rpcManager.blocking(completionStage);
            for (Map.Entry<Address, Response> re : addressResponseMap.entrySet()) {
                Response r = re.getValue();
                if (!this.isSuccessful(r)) {
                    throw new CacheException("Could not fetch in doubt transactions: " + String.valueOf(r));
                }
                Set infoInDoubtSet = (Set)((SuccessfulResponse)r).getResponseValue();
                for (InDoubtTxInfo infoInDoubt : infoInDoubtSet) {
                    InDoubtTxInfo inDoubtTxInfo = (InDoubtTxInfo)result.get(infoInDoubt.getXid());
                    if (inDoubtTxInfo == null) {
                        inDoubtTxInfo = infoInDoubt;
                        result.put(infoInDoubt.getXid(), inDoubtTxInfo);
                    } else {
                        inDoubtTxInfo.setStatus(infoInDoubt.getStatus());
                    }
                    inDoubtTxInfo.addOwner(re.getKey());
                }
            }
        }
        Set<InDoubtTxInfo> onThisNode = this.getInDoubtTransactionInfo();
        Iterator<InDoubtTxInfo> iterator = onThisNode.iterator();
        while (iterator.hasNext()) {
            InDoubtTxInfo info = iterator.next();
            InDoubtTxInfo inDoubtTxInfo = (InDoubtTxInfo)result.get(info.getXid());
            if (inDoubtTxInfo != null) {
                inDoubtTxInfo.setLocal(true);
                iterator.remove();
                continue;
            }
            info.setLocal(true);
        }
        HashSet<InDoubtTxInfo> value = new HashSet<InDoubtTxInfo>(result.values());
        value.addAll(onThisNode);
        return value;
    }

    @Override
    public void registerInDoubtTransaction(RecoveryAwareRemoteTransaction remoteTransaction) {
        XidImpl xid = remoteTransaction.getGlobalTransaction().getXid();
        RecoveryAwareTransaction previous = this.inDoubtTransactions.put(new RecoveryInfoKey(xid, this.cacheName), remoteTransaction);
        if (previous != null) {
            log.preparedTxAlreadyExists(previous, remoteTransaction);
            throw new IllegalStateException("Are there two different transactions having same Xid in the cluster?");
        }
    }

    @Override
    public RecoveryAwareRemoteTransaction getPreparedTransaction(XidImpl xid) {
        return (RecoveryAwareRemoteTransaction)this.inDoubtTransactions.get(new RecoveryInfoKey(xid, this.cacheName));
    }

    @Override
    public CompletionStage<String> forceTransactionCompletion(XidImpl xid, boolean commit) {
        LocalXaTransaction localTransaction = this.recoveryAwareTxTable().getLocalTransaction(xid);
        if (localTransaction != null) {
            localTransaction.clearRemoteLocksAcquired();
            return this.completeTransaction(localTransaction, commit, xid);
        }
        RecoveryAwareRemoteTransaction tx = this.getPreparedTransaction(xid);
        if (tx == null) {
            return CompletableFuture.completedFuture("Could not find transaction " + String.valueOf(xid));
        }
        GlobalTransaction globalTransaction = tx.getGlobalTransaction();
        globalTransaction.setAddress(this.rpcManager.getAddress());
        globalTransaction.setRemote(false);
        RecoveryAwareLocalTransaction localTx = (RecoveryAwareLocalTransaction)this.txFactory.newLocalTransaction(null, globalTransaction, false, tx.getTopologyId());
        localTx.setModifications(tx.getModifications());
        localTx.setXid(xid);
        localTx.addAllAffectedKeys(tx.getAffectedKeys());
        for (Object lk : tx.getLockedKeys()) {
            localTx.registerLockedKey(lk);
        }
        return this.completeTransaction(localTx, commit, xid);
    }

    private CompletionStage<String> completeTransaction(LocalTransaction localTx, boolean commit, XidImpl xid) {
        GlobalTransaction gtx = localTx.getGlobalTransaction();
        if (commit) {
            localTx.clearLookedUpEntries();
            return this.txCoordinator.prepare(localTx, true).thenCompose(ignore -> this.txCoordinator.commit(localTx, false)).thenCompose(ignore -> this.removeRecoveryInformation(null, xid, gtx, false)).thenApply(ignore -> "Commit successful!").exceptionally(t2 -> {
                log.warnCouldNotCommitLocalTx(localTx, (Throwable)t2);
                return "Could not commit transaction " + String.valueOf(xid) + " : " + t2.getMessage();
            });
        }
        return this.txCoordinator.rollback(localTx).thenCompose(ignore -> this.removeRecoveryInformation(null, xid, gtx, false)).thenApply(ignore -> "Rollback successful").exceptionally(t2 -> {
            log.warnCouldNotRollbackLocalTx(localTx, (Throwable)t2);
            return "Could not rollback transaction " + String.valueOf(xid) + " : " + t2.getMessage();
        });
    }

    @Override
    public String forceTransactionCompletionFromCluster(XidImpl xid, Address where, boolean commit) {
        CompleteTransactionCommand ctc = this.commandFactory.buildCompleteTransactionCommand(xid, commit);
        CompletionStage<Map<Address, Response>> completionStage = this.rpcManager.invokeCommand(where, (ReplicableCommand)ctc, MapResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions());
        Map<Address, Response> responseMap = this.rpcManager.blocking(completionStage);
        if (responseMap.size() != 1 || responseMap.get(where) == null) {
            log.expectedJustOneResponse(responseMap);
            throw new CacheException("Expected response size is 1, received " + String.valueOf(responseMap));
        }
        return (String)((SuccessfulResponse)responseMap.get(where)).getResponseValue();
    }

    @Override
    public boolean isTransactionPrepared(GlobalTransaction globalTx) {
        boolean result;
        XidImpl xid = globalTx.getXid();
        RecoveryAwareRemoteTransaction remoteTransaction = (RecoveryAwareRemoteTransaction)this.recoveryAwareTxTable().getRemoteTransaction(globalTx);
        boolean remotePrepared = remoteTransaction != null && remoteTransaction.isPrepared();
        boolean bl = result = this.inDoubtTransactions.get(new RecoveryInfoKey(xid, this.cacheName)) != null || this.recoveryAwareTxTable().getLocalPreparedXids().contains(xid) || remotePrepared;
        if (log.isTraceEnabled()) {
            log.tracef("Is tx %s prepared? %s", (Object)xid, (Object)result);
        }
        return result;
    }

    private RecoveryAwareTransactionTable recoveryAwareTxTable() {
        return (RecoveryAwareTransactionTable)this.txTable.running();
    }

    private boolean isSuccessful(Response thisResponse) {
        return thisResponse != null && thisResponse.isValid() && thisResponse.isSuccessful();
    }

    private boolean notOnlyMeInTheCluster() {
        return this.rpcManager != null && this.rpcManager.getTransport().getMembers().size() > 1;
    }

    private Map<Address, Response> getAllPreparedTxFromCluster() {
        GetInDoubtTransactionsCommand command = this.commandFactory.buildGetInDoubtTransactionsCommand();
        CompletionStage<Map<Address, Response>> completionStage = this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        Map<Address, Response> addressResponseMap = this.rpcManager.blocking(completionStage);
        if (log.isTraceEnabled()) {
            log.tracef("getAllPreparedTxFromCluster received from cluster: %s", (Object)addressResponseMap);
        }
        return addressResponseMap;
    }

    public ConcurrentMap<RecoveryInfoKey, RecoveryAwareRemoteTransaction> getInDoubtTransactionsMap() {
        return this.inDoubtTransactions;
    }
}

