/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.marshall.core.Ids;

public class KeyValuePair<K, V> {
    private final K key;
    private final V value;

    public static <K, V> KeyValuePair<K, V> of(K key, V value) {
        return new KeyValuePair<K, V>(key, value);
    }

    public KeyValuePair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyValuePair)) {
            return false;
        }
        KeyValuePair that = (KeyValuePair)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "KeyValuePair{key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + "}";
    }

    public static class Externalizer
    extends AbstractExternalizer<KeyValuePair> {
        private static final long serialVersionUID = -5291318076267612501L;

        @Override
        public void writeObject(ObjectOutput output, KeyValuePair kvPair) throws IOException {
            output.writeObject(kvPair.getKey());
            output.writeObject(kvPair.getValue());
        }

        @Override
        public KeyValuePair readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new KeyValuePair<Object, Object>(input.readObject(), input.readObject());
        }

        @Override
        public Integer getId() {
            return Ids.KEY_VALUE_PAIR_ID;
        }

        @Override
        public Set<Class<? extends KeyValuePair>> getTypeClasses() {
            return Collections.singleton(KeyValuePair.class);
        }
    }
}

