/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.remoting.RpcException;

public class BackupFailureException
extends RpcException {
    private Map<String, Throwable> failures;
    private String localCacheName;

    public BackupFailureException(String localCacheName) {
        this.localCacheName = localCacheName;
    }

    public BackupFailureException() {
    }

    public void addFailure(String site, Throwable t2) {
        if (site != null && t2 != null) {
            if (this.failures == null) {
                this.failures = new HashMap<String, Throwable>(3);
            }
            this.failures.put(site, t2);
        }
    }

    public String getRemoteSiteNames() {
        return this.failures != null ? this.failures.keySet().toString() : null;
    }

    public String getLocalCacheName() {
        return this.localCacheName;
    }

    @Override
    public String getMessage() {
        if (this.failures == null || this.failures.isEmpty()) {
            return super.getMessage();
        }
        return "The local cache " + this.localCacheName + " failed to backup data to the remote sites:\n" + this.failures.entrySet().stream().map(e -> (String)e.getKey() + ": " + String.valueOf(e.getValue())).collect(Collectors.joining("\n"));
    }
}

