/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteNamedCache;

@Listener
@Scope(value=Scopes.GLOBAL)
public class XSiteCacheMapper {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    GlobalComponentRegistry registry;
    @Inject
    ConfigurationManager configurationManager;
    @Inject
    CacheManagerNotifier notifier;
    private final Map<RemoteCacheInfoImpl, LocalCacheInfoImpl> localCachesMap = new ConcurrentHashMap<RemoteCacheInfoImpl, LocalCacheInfoImpl>();

    public LocalCacheInfo findLocalCache(String remoteSite, ByteString remoteCacheName) {
        RemoteCacheInfoImpl key = new RemoteCacheInfoImpl(remoteSite, remoteCacheName);
        return this.localCachesMap.computeIfAbsent(key, this::lookupLocalCaches);
    }

    Optional<LocalCacheInfo> peekLocalCacheForRemoteSite(String remoteSite, ByteString remoteCache) {
        return Optional.ofNullable((LocalCacheInfo)this.localCachesMap.get(new RemoteCacheInfoImpl(remoteSite, remoteCache)));
    }

    @Start
    public void start() {
        this.notifier.addListener(this);
    }

    @Stop
    public void stop() {
        this.notifier.removeListener(this);
        this.localCachesMap.clear();
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        ByteString cacheName = ByteString.fromString(event.getCacheName());
        log.debugf("On cache stopped event. Removing map to cache %s", (Object)cacheName);
        this.localCachesMap.entrySet().removeIf(entry -> ((LocalCacheInfoImpl)entry.getValue()).cacheName.equals(cacheName));
    }

    public Stream<ByteString> remoteCachesFromSite(ByteString site) {
        return this.getCacheNames().stream().map(this::getConfiguration).filter(Objects::nonNull).filter(NamedConfiguration::isClustered).filter(c -> c.isAsyncBackupTo(site)).map(c -> c.cacheNameInSite(site));
    }

    private LocalCacheInfoImpl lookupLocalCaches(RemoteCacheInfoImpl remoteCache) {
        Optional<LocalCacheInfoImpl> optConf = this.getCacheNames().stream().map(this::getConfiguration).filter(Objects::nonNull).filter(remoteCache::isBackupFor).findFirst().or(() -> this.findConfiguration(remoteCache.originCache.toString())).map(NamedConfiguration::toLocalCacheInfo);
        if (optConf.isPresent()) {
            LocalCacheInfoImpl local = optConf.get();
            log.debugf("Found local cache '%s' is backup for cache '%s' from site '%s'", (Object)local.cacheName, (Object)remoteCache.originCache, (Object)remoteCache.originSite);
            return optConf.get();
        }
        log.debugf("No local cache found for cache '%s' from site '%s'", (Object)remoteCache.originCache, (Object)remoteCache.originSite);
        return null;
    }

    private Optional<NamedConfiguration> findConfiguration(String cacheName) {
        Configuration c = this.configurationManager.getConfiguration(cacheName, false);
        return c == null ? Optional.empty() : Optional.of(new NamedConfiguration(cacheName, c));
    }

    private NamedConfiguration getConfiguration(String cacheName) {
        return this.findConfiguration(cacheName).orElse(null);
    }

    private Collection<String> getCacheNames() {
        return this.registry.getCacheManager().getCacheNames();
    }

    public Stream<RemoteCacheInfo> findRemoteCachesWithAsyncBackup(String cacheName) {
        return this.findConfiguration(cacheName).map(NamedConfiguration::remoteAsyncSiteAndCaches).orElse(Stream.empty());
    }

    private static class RemoteCacheInfoImpl
    implements RemoteCacheInfo {
        private final ByteString originSite;
        private final ByteString originCache;

        RemoteCacheInfoImpl(String originSite, ByteString originCache) {
            this.originSite = XSiteNamedCache.cachedByteString(Objects.requireNonNull(originSite));
            this.originCache = Objects.requireNonNull(originCache);
        }

        boolean isBackupFor(NamedConfiguration namedConfiguration) {
            return namedConfiguration.configuration.sites().backupFor().isBackupFor(this.originSite.toString(), this.originCache.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteCacheInfoImpl remoteSiteCache = (RemoteCacheInfoImpl)o;
            return Objects.equals(this.originSite, remoteSiteCache.originSite) && Objects.equals(this.originCache, remoteSiteCache.originCache);
        }

        public int hashCode() {
            return Objects.hash(this.originSite, this.originCache);
        }

        public String toString() {
            return "RemoteCacheInfo{originSite=" + String.valueOf(this.originSite) + ", originCache=" + String.valueOf(this.originCache) + "}";
        }

        @Override
        public ByteString cacheName() {
            return this.originCache;
        }

        @Override
        public ByteString siteName() {
            return this.originSite;
        }
    }

    public static interface LocalCacheInfo {
        public ByteString cacheName();

        public boolean isLocalOnly();
    }

    private static class LocalCacheInfoImpl
    implements LocalCacheInfo {
        private final ByteString cacheName;
        private final boolean local;

        LocalCacheInfoImpl(ByteString cacheName, boolean local) {
            this.cacheName = Objects.requireNonNull(cacheName);
            this.local = local;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalCacheInfoImpl that = (LocalCacheInfoImpl)o;
            return this.local == that.local && Objects.equals(this.cacheName, that.cacheName);
        }

        public int hashCode() {
            return Objects.hash(this.cacheName, this.local);
        }

        @Override
        public ByteString cacheName() {
            return this.cacheName;
        }

        @Override
        public boolean isLocalOnly() {
            return this.local;
        }

        public String toString() {
            return "LocalCacheInfoImpl{cacheName=" + String.valueOf(this.cacheName) + ", local=" + this.local + "}";
        }
    }

    private static class NamedConfiguration {
        final ByteString name;
        final Configuration configuration;

        NamedConfiguration(String name, Configuration configuration) {
            this.name = ByteString.fromString(Objects.requireNonNull(name));
            this.configuration = Objects.requireNonNull(configuration);
        }

        LocalCacheInfoImpl toLocalCacheInfo() {
            return new LocalCacheInfoImpl(this.name, !this.isClustered());
        }

        boolean isClustered() {
            return this.configuration.clustering().cacheMode().isClustered();
        }

        boolean isAsyncBackupTo(ByteString remoteSite) {
            return this.asyncBackups().anyMatch(c -> Objects.equals(remoteSite.toString(), c.site()));
        }

        Stream<BackupConfiguration> asyncBackups() {
            return this.configuration.sites().asyncBackupsStream();
        }

        BackupForConfiguration backupForConfiguration() {
            return this.configuration.sites().backupFor();
        }

        ByteString cacheNameInSite(ByteString remoteSite) {
            BackupForConfiguration backupFor = this.backupForConfiguration();
            return Objects.equals(remoteSite.toString(), backupFor.remoteSite()) ? ByteString.fromString(backupFor.remoteCache()) : this.name;
        }

        Stream<RemoteCacheInfo> remoteAsyncSiteAndCaches() {
            return this.asyncBackups().map(c -> {
                if (Objects.equals(this.backupForConfiguration().remoteSite(), c.site())) {
                    return new RemoteCacheInfoImpl(c.site(), ByteString.fromString(this.backupForConfiguration().remoteCache()));
                }
                return new RemoteCacheInfoImpl(c.site(), this.name);
            });
        }

        public String toString() {
            return "NamedConfiguration{name=" + String.valueOf(this.name) + ", configuration=" + String.valueOf(this.configuration) + "}";
        }
    }

    public static interface RemoteCacheInfo {
        public ByteString cacheName();

        public ByteString siteName();
    }
}

