/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.GlobalRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.xsite.events.XSiteEvent;
import org.infinispan.xsite.events.XSiteEventsManager;

public class XSiteLocalEventCommand
implements GlobalRpcCommand {
    public static final byte COMMAND_ID = 15;
    private List<XSiteEvent> events;

    public XSiteLocalEventCommand() {
    }

    public XSiteLocalEventCommand(List<XSiteEvent> events) {
        this.events = events;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry globalComponentRegistry) throws Throwable {
        return globalComponentRegistry.getComponent(XSiteEventsManager.class).onLocalEvents(this.events);
    }

    @Override
    public byte getCommandId() {
        return 15;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.events, output, XSiteEvent::writeTo);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.events = MarshallUtil.unmarshallCollection(input, ArrayList::new, XSiteEvent::readFrom);
    }

    public String toString() {
        return "XSiteLocalEventCommand{events=" + String.valueOf(this.events) + "}";
    }
}

