/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;

public class XSiteStateTransferFinishReceiveCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 107;
    private String siteName;

    public XSiteStateTransferFinishReceiveCommand() {
        this(null, null);
    }

    public XSiteStateTransferFinishReceiveCommand(ByteString cacheName) {
        this(cacheName, null);
    }

    public XSiteStateTransferFinishReceiveCommand(ByteString cacheName, String siteName) {
        super(cacheName);
        this.siteName = siteName;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        registry.getXSiteStateTransferManager().running().getStateConsumer().endStateTransfer(this.siteName);
        return CompletableFutures.completedNull();
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Override
    public byte getCommandId() {
        return 107;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString(this.siteName, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.siteName = MarshallUtil.unmarshallString(input);
    }

    @Override
    public String toString() {
        return "XSiteStateTransferFinishReceiveCommand{siteName='" + this.siteName + "', cacheName=" + String.valueOf(this.cacheName) + "}";
    }
}

