/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.xsite.commands.remote.XSiteRequest;
import org.infinispan.xsite.events.XSiteEvent;
import org.infinispan.xsite.events.XSiteEventsManager;

public class XSiteRemoteEventCommand
implements XSiteRequest<Void> {
    private List<XSiteEvent> events;

    public XSiteRemoteEventCommand() {
    }

    public XSiteRemoteEventCommand(List<XSiteEvent> events) {
        this.events = events;
    }

    @Override
    public CompletionStage<Void> invokeInLocalSite(String origin, GlobalComponentRegistry registry) {
        return registry.getComponent(XSiteEventsManager.class).onRemoteEvents(this.events);
    }

    @Override
    public byte getCommandId() {
        return 7;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.events, output, XSiteEvent::writeTo);
    }

    @Override
    public XSiteRequest<Void> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.events = MarshallUtil.unmarshallCollection(input, ArrayList::new, XSiteEvent::readFrom);
        return this;
    }

    public String toString() {
        return "XSiteRemoteEventCommand{events=" + String.valueOf(this.events) + "}";
    }
}

