/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.commands.remote.XSiteCacheRequest;
import org.infinispan.xsite.commands.remote.XSiteRequest;
import org.infinispan.xsite.statetransfer.XSiteState;

public class XSiteStatePushRequest
extends XSiteCacheRequest<Void> {
    private XSiteState[] chunk;
    private long timeoutMillis;

    public XSiteStatePushRequest() {
        super(null);
    }

    public XSiteStatePushRequest(ByteString cacheName, XSiteState[] chunk, long timeoutMillis) {
        super(cacheName);
        this.chunk = chunk;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    protected CompletionStage<Void> invokeInLocalCache(String origin, ComponentRegistry registry) {
        return registry.getBackupReceiver().running().handleStateTransferState(this.chunk, this.timeoutMillis);
    }

    @Override
    public byte getCommandId() {
        return 1;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.timeoutMillis);
        MarshallUtil.marshallArray(this.chunk, output);
        super.writeTo(output);
    }

    @Override
    public XSiteRequest<Void> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.timeoutMillis = input.readLong();
        this.chunk = (XSiteState[])MarshallUtil.unmarshallArray(input, XSiteState[]::new);
        return super.readFrom(input);
    }
}

