/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.events;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteRemoteEventCommand;
import org.infinispan.xsite.events.XSiteEvent;

public class XSiteEventSender
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Transport transport;
    private final Map<ByteString, EventList> eventsToRemoteSites = new ConcurrentHashMap<ByteString, EventList>(4);

    public XSiteEventSender(Transport transport) {
        this.transport = transport;
    }

    public void addEventToSite(ByteString site, XSiteEvent event) {
        log.debugf("Added event %s to %s", (Object)event, (Object)site);
        this.eventsToRemoteSites.computeIfAbsent(site, EventList::new).add(event);
    }

    @Override
    public void close() {
        log.debugf("Flushing events: %s", (Object)this.eventsToRemoteSites.values());
        for (EventList eventList : this.eventsToRemoteSites.values()) {
            XSiteRemoteEventCommand cmd = new XSiteRemoteEventCommand(eventList.events);
            XSiteBackup backup = new XSiteBackup(eventList.site.toString(), false, 10000L);
            this.transport.backupRemotely(backup, cmd);
        }
    }

    private static class EventList {
        final ByteString site;
        final List<XSiteEvent> events;

        EventList(ByteString site) {
            this.site = site;
            this.events = Collections.synchronizedList(new LinkedList());
        }

        void add(XSiteEvent event) {
            this.events.add(event);
        }

        public String toString() {
            return "EventList{site=" + String.valueOf(this.site) + ", events=" + String.valueOf(this.events) + "}";
        }
    }
}

