/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.events;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.SiteViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.SitesViewChangedEvent;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteCacheMapper;
import org.infinispan.xsite.XSiteNamedCache;
import org.infinispan.xsite.commands.XSiteLocalEventCommand;
import org.infinispan.xsite.commands.remote.XSiteRemoteEventCommand;
import org.infinispan.xsite.events.XSiteEvent;
import org.infinispan.xsite.events.XSiteEventSender;
import org.infinispan.xsite.events.XSiteEventType;
import org.infinispan.xsite.events.XSiteEventsManager;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

@Listener
@Scope(value=Scopes.GLOBAL)
public class XSiteEventsManagerImpl
implements XSiteEventsManager {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    Transport transport;
    @Inject
    CacheManagerNotifier notifier;
    @Inject
    GlobalComponentRegistry globalRegistry;
    @Inject
    XSiteCacheMapper xSiteCacheMapper;

    @Start
    public void start() {
        this.notifier.addListener(this);
    }

    @Stop
    public void stop() {
        this.notifier.removeListener(this);
    }

    @Override
    public CompletionStage<Void> onLocalEvents(List<XSiteEvent> events) {
        log.debugf("Local events received: %s", (Object)events);
        try (XSiteEventSender holder = new XSiteEventSender(this.transport);){
            block11: for (XSiteEvent e : events) {
                switch (e.getType()) {
                    case SITE_CONNECTED: {
                        this.onRemoteSiteConnected(e.getSiteName(), holder);
                        continue block11;
                    }
                    case STATE_REQUEST: 
                    case INITIAL_STATE_REQUEST: {
                        this.onRemoteSiteStateRequest(e.getSiteName(), e.getCacheName(), e.getType() == XSiteEventType.INITIAL_STATE_REQUEST);
                        continue block11;
                    }
                }
                log.debugf("Unknown event received: %s", (Object)e);
            }
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> onRemoteEvents(List<XSiteEvent> events) {
        log.debugf("Remote events received: %s", (Object)events);
        if (this.transport.isCoordinator()) {
            return this.onLocalEvents(events);
        }
        try {
            log.debugf("Forwarding events to coordinator: %s", (Object)events);
            this.transport.sendTo(this.transport.getCoordinator(), new XSiteLocalEventCommand(events), DeliverOrder.PER_SENDER);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.completedNull();
    }

    @SiteViewChanged
    public void onSiteViewChanged(SitesViewChangedEvent event) {
        if (!this.transport.isPrimaryRelayNode()) {
            return;
        }
        log.debugf("On site view changed event: %s", (Object)event);
        event.getJoiners().stream().filter(s2 -> !Objects.equals(s2, this.localSite().toString())).forEach(this::sendNewConnectionEvent);
    }

    @CacheStarted
    public void onCacheStarted(CacheStartedEvent event) {
        log.debugf("On cache started (is coordinator? %s): %s", (Object)this.transport.isCoordinator(), (Object)event.getCacheName());
        if (!this.transport.isCoordinator()) {
            return;
        }
        try (XSiteEventSender sender = new XSiteEventSender(this.transport);){
            this.xSiteCacheMapper.findRemoteCachesWithAsyncBackup(event.getCacheName()).forEach(i -> sender.addEventToSite(i.siteName(), XSiteEvent.createInitialStateRequest(this.localSite(), i.cacheName())));
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Unable to send state request for cache %s", (Object)event.getCacheName());
        }
    }

    private void onRemoteSiteConnected(ByteString site, XSiteEventSender sender) {
        Iterator it = this.xSiteCacheMapper.remoteCachesFromSite(site).iterator();
        while (it.hasNext()) {
            sender.addEventToSite(site, XSiteEvent.createRequestState(this.localSite(), (ByteString)it.next()));
        }
    }

    private void sendNewConnectionEvent(String remoteSite) {
        XSiteRemoteEventCommand cmd = new XSiteRemoteEventCommand(List.of(XSiteEvent.createConnectEvent(this.localSite())));
        XSiteBackup backup = new XSiteBackup(remoteSite, false, 10000L);
        log.debugf("Sending connection event to %s: %s", (Object)backup, (Object)cmd);
        this.transport.backupRemotely(backup, cmd);
    }

    private void onRemoteSiteStateRequest(ByteString remoteSite, ByteString localCacheName, boolean initialState) {
        ComponentRegistry cacheRegistry = this.globalRegistry.getNamedComponentRegistry(localCacheName);
        if (cacheRegistry == null) {
            log.debugf("State Transfer request from site '%s' and cache '%s' failed. Cache does no exist.", (Object)remoteSite, (Object)localCacheName);
            return;
        }
        ComponentRef<XSiteStateTransferManager> xsiteStateManagerRef = cacheRegistry.getXSiteStateTransferManager();
        if (!xsiteStateManagerRef.isRunning()) {
            log.debugf("State Transfer request from site '%s' and cache '%s' failed. Cache is not started.", (Object)remoteSite, (Object)localCacheName);
            return;
        }
        xsiteStateManagerRef.running().startAutomaticStateTransferTo(remoteSite, initialState);
    }

    private ByteString localSite() {
        return XSiteNamedCache.cachedByteString(this.transport.localSiteName());
    }
}

