/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jgroups.Address;
import org.jgroups.util.Util;

public class Membership {
    protected final List<Address> members = new LinkedList<Address>();

    public Membership() {
    }

    public Membership(Collection<Address> initial_members) {
        if (initial_members != null) {
            this.add(initial_members);
        }
    }

    public Membership(Address ... initial_members) {
        if (initial_members != null) {
            this.add(initial_members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getMembers() {
        List<Address> list = this.members;
        synchronized (list) {
            return new ArrayList<Address>(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership add(Address new_member) {
        if (new_member == null) {
            return this;
        }
        List<Address> list = this.members;
        synchronized (list) {
            if (!this.members.contains(new_member)) {
                this.members.add(new_member);
            }
        }
        return this;
    }

    public Membership add(Address ... mbrs) {
        for (Address mbr : mbrs) {
            this.add(mbr);
        }
        return this;
    }

    public Membership add(Collection<Address> v) {
        if (v != null) {
            v.forEach(this::add);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership remove(Address old_member) {
        if (old_member != null) {
            List<Address> list = this.members;
            synchronized (list) {
                this.members.remove(old_member);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership remove(Collection<Address> v) {
        if (v != null) {
            List<Address> list = this.members;
            synchronized (list) {
                this.members.removeAll(v);
            }
        }
        return this;
    }

    public Membership removeAll(Membership m4) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership retainAll(Collection<Address> v) {
        if (v != null) {
            List<Address> list = this.members;
            synchronized (list) {
                this.members.retainAll(v);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership clear() {
        List<Address> list = this.members;
        synchronized (list) {
            this.members.clear();
        }
        return this;
    }

    public Membership set(Collection<Address> v) {
        this.clear();
        return this.add(v);
    }

    public Membership set(Membership m4) {
        this.clear();
        if (m4 != null) {
            this.add(m4.getMembers());
        }
        return this;
    }

    public Membership merge(Collection<Address> new_mems, Collection<Address> suspects) {
        this.remove(suspects);
        return this.add(new_mems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Address member) {
        if (member == null) {
            return false;
        }
        List<Address> list = this.members;
        synchronized (list) {
            return this.members.contains(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership sort() {
        List<Address> list = this.members;
        synchronized (list) {
            Collections.sort(this.members);
        }
        return this;
    }

    public Membership copy() {
        return new Membership(this.members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<Address> list = this.members;
        synchronized (list) {
            return this.members.size();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address elementAt(int index) {
        List<Address> list = this.members;
        synchronized (list) {
            return this.members.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getFirst() {
        List<Address> list = this.members;
        synchronized (list) {
            return this.members.isEmpty() ? null : this.members.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCoord(Address mbr) {
        List<Address> list = this.members;
        synchronized (list) {
            return mbr != null && Objects.equals(mbr, this.getFirst());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getPrevious(Address mbr) {
        Address next;
        if (mbr == null) {
            return null;
        }
        List<Address> list = this.members;
        synchronized (list) {
            next = Util.pickPrevious(this.members, mbr);
        }
        return Objects.equals(mbr, next) ? null : next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getNext(Address mbr) {
        Address next;
        if (mbr == null) {
            return null;
        }
        List<Address> list = this.members;
        synchronized (list) {
            next = Util.pickNext(this.members, mbr);
        }
        return Objects.equals(mbr, next) ? null : next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<Address> list = this.members;
        synchronized (list) {
            return Util.printListWithDelimiter(this.members, ",");
        }
    }
}

