/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.BaseMessage;
import org.jgroups.Message;
import org.jgroups.util.ByteArray;
import org.jgroups.util.ObjectWrapperPrimitive;
import org.jgroups.util.ObjectWrapperSerializable;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class ObjectMessage
extends BaseMessage {
    protected SizeStreamable obj;

    public ObjectMessage() {
        this(null);
    }

    public ObjectMessage(Address dest) {
        this(dest, null);
    }

    public ObjectMessage(Address dest, Object obj) {
        super(dest);
        this.setObject(obj);
    }

    public ObjectMessage(Address dest, SizeStreamable obj) {
        super(dest);
        this.setObject(obj);
    }

    @Override
    public Supplier<Message> create() {
        return ObjectMessage::new;
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public boolean hasPayload() {
        return this.obj != null;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public int getLength() {
        return this.obj != null ? this.objSize() : 0;
    }

    @Override
    public byte[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectMessage setArray(byte[] b, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectMessage setArray(ByteArray buf) {
        throw new UnsupportedOperationException();
    }

    public boolean isWrapped() {
        return this.isFlagSet(Message.Flag.SERIALIZED);
    }

    public ObjectMessage setWrapped(boolean b) {
        if (b) {
            this.setFlag(Message.Flag.SERIALIZED);
        } else {
            this.clearFlag(Message.Flag.SERIALIZED);
        }
        return this;
    }

    @Override
    public ObjectMessage setObject(Object obj) {
        if (obj == null) {
            this.obj = null;
            this.setWrapped(false);
            return this;
        }
        if (Util.isPrimitiveType(obj)) {
            this.obj = new ObjectWrapperPrimitive(obj);
            this.setWrapped(true);
            return this;
        }
        if (obj instanceof SizeStreamable) {
            this.obj = (SizeStreamable)obj;
            this.setWrapped(false);
        } else {
            this.obj = new ObjectWrapperSerializable(obj);
            this.setWrapped(true);
        }
        return this;
    }

    public ObjectMessage setObject(SizeStreamable obj) {
        this.setWrapped(false);
        if (obj == null) {
            this.obj = null;
            return this;
        }
        this.obj = obj;
        return this;
    }

    public ObjectMessage setSizeStreamable(SizeStreamable s2) {
        return this.setObject(s2);
    }

    @Override
    public <T> T getObject() {
        if (this.obj == null) {
            return null;
        }
        return (T)(this.isWrapped() || this.obj instanceof ObjectWrapperPrimitive ? ((ObjectWrapperPrimitive)this.obj).getObject() : this.obj);
    }

    @Override
    public int size() {
        return super.size() + this.objSize();
    }

    @Override
    public void writePayload(DataOutput out) throws IOException {
        Util.writeGenericStreamable(this.obj, out);
    }

    @Override
    public void readPayload(DataInput in) throws IOException, ClassNotFoundException {
        this.obj = Util.readSizeStreamable(in, null);
    }

    @Override
    protected Message copyPayload(Message copy) {
        if (this.obj != null) {
            ((ObjectMessage)copy).setObject(this.obj);
        }
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + String.format(", obj: %s", this.obj);
    }

    protected int objSize() {
        return Util.size(this.obj);
    }
}

