/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ObjectMessage;
import org.jgroups.Receiver;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodInvoker;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcher
extends MessageDispatcher {
    protected Object server_obj;
    protected MethodLookup method_lookup;
    protected MethodInvoker method_invoker;

    public RpcDispatcher() {
    }

    public RpcDispatcher(JChannel channel, Object server_obj) {
        super(channel);
        this.setRequestHandler(this);
        this.server_obj = server_obj;
    }

    public Object getServerObject() {
        return this.server_obj;
    }

    public RpcDispatcher setServerObject(Object obj) {
        this.server_obj = obj;
        return this;
    }

    public RpcDispatcher setReceiver(Receiver r) {
        return (RpcDispatcher)super.setReceiver(r);
    }

    public MethodLookup getMethodLookup() {
        return this.method_lookup;
    }

    public RpcDispatcher setMethodLookup(MethodLookup ml) {
        this.method_lookup = ml;
        return this;
    }

    public MethodInvoker getMethodInvoker() {
        return this.method_invoker;
    }

    public RpcDispatcher setMethodInvoker(MethodInvoker mi) {
        this.method_invoker = mi;
        return this;
    }

    public <T> RspList<T> callRemoteMethods(Collection<Address> dests, String method_name, Object[] args, Class<?>[] types, RequestOptions options) throws Exception {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, options);
    }

    public <T> RspList<T> callRemoteMethods(Collection<Address> dests, MethodCall method_call, RequestOptions opts) throws Exception {
        if (dests != null && dests.isEmpty()) {
            this.log.trace("destination list of %s() is empty: no need to send message", method_call.getMethodName());
            return empty_rsplist;
        }
        ObjectMessage msg = new ObjectMessage(null, method_call);
        RspList retval = super.castMessage(dests, msg, opts);
        if (this.log.isTraceEnabled()) {
            this.log.trace("dests=%s, method_call=%s, options=%s, responses: %s", dests, method_call, opts, retval);
        }
        return retval;
    }

    public <T> CompletableFuture<RspList<T>> callRemoteMethodsWithFuture(Collection<Address> dests, MethodCall call, RequestOptions options) throws Exception {
        if (dests != null && dests.isEmpty()) {
            this.log.trace("destination list of %s() is empty: no need to send message", call.getMethodName());
            return CompletableFuture.completedFuture(empty_rsplist);
        }
        ObjectMessage msg = new ObjectMessage(null, call);
        CompletableFuture retval = super.castMessageWithFuture(dests, msg, options);
        if (this.log.isTraceEnabled()) {
            this.log.trace("dests=%s, method_call=%s, options=%s", dests, call, options);
        }
        return retval;
    }

    public <T> T callRemoteMethod(Address dest, String meth, Object[] args, Class<?>[] types, RequestOptions opts) throws Exception {
        MethodCall method_call = new MethodCall(meth, args, types);
        return this.callRemoteMethod(dest, method_call, opts);
    }

    public <T> T callRemoteMethod(Address dest, MethodCall call, RequestOptions options) throws Exception {
        ObjectMessage req = new ObjectMessage(dest, call);
        Object retval = super.sendMessage(req, options);
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=%s, method_call=%s, options=%s, retval: %s", dest, call, options, retval);
        }
        return retval;
    }

    public <T> CompletableFuture<T> callRemoteMethodWithFuture(Address dest, MethodCall call, RequestOptions opts) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=%s, method_call=%s, options=%s", dest, call, opts);
        }
        ObjectMessage msg = new ObjectMessage(dest, call);
        return super.sendMessageWithFuture(msg, opts);
    }

    @Override
    public Object handle(Message req) throws Exception {
        if (this.server_obj == null) {
            this.log.error(Util.getMessage("NoMethodHandlerIsRegisteredDiscardingRequest"));
            return null;
        }
        if (req == null || req.getLength() == 0) {
            this.log.error(Util.getMessage("MessageOrMessageBufferIsNull"));
            return null;
        }
        MethodCall method_call = (MethodCall)req.getObject();
        if (this.log.isTraceEnabled()) {
            this.log.trace("[sender=%s], method_call: %s", req.getSrc(), method_call);
        }
        if (method_call.useIds()) {
            if (this.method_invoker != null) {
                return this.method_invoker.invoke(this.server_obj, method_call.getMethodId(), method_call.getArgs());
            }
            if (this.method_lookup == null) {
                throw new Exception(String.format("MethodCall uses ID=%d, but method_lookup has not been set", method_call.getMethodId()));
            }
            Method m4 = this.method_lookup.findMethod(method_call.getMethodId());
            if (m4 == null) {
                throw new Exception("no method found for " + method_call.getMethodId());
            }
            method_call.setMethod(m4);
        }
        return method_call.invoke(this.server_obj);
    }
}

